/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.mixins;

import java.io.IOException;
import javax.inject.Inject;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.metadata.TypeMetadata;
import javax.xml.bind.JAXBException;
import org.apache.causeway.applib.CausewayModuleApplib;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.persistence.jdo.applib.services.JdoSupportService;
import org.datanucleus.enhancement.Persistable;

@Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE)
@ActionLayout(cssClassFa="fa-download", describedAs="Downloads the DataNucleus metamodel for this class (as a Xxx.jdo file).  One use case is to tactically override annotation-based configuration of existing entities, eg to target specific databases", fieldSetId="metadata", position=ActionLayout.Position.PANEL_DROPDOWN, sequence="710.1")
public class Persistable_downloadJdoMetadata {
    @Inject
    JdoSupportService jdoSupport;
    private final Persistable persistable;

    @MemberSupport
    public Clob act(String fileName) throws JAXBException, IOException {
        Class<?> objClass = this.persistable.getClass();
        String objClassName = objClass.getName();
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(objClassName);
        String xml = metadata.toString();
        return new Clob(_Strings.asFileNameWithExtension((String)fileName, (String)"jdo"), "text/xml", (CharSequence)xml);
    }

    @MemberSupport
    public String default0Act() {
        return _Strings.asFileNameWithExtension((String)this.persistable.getClass().getName(), (String)"jdo");
    }

    private PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoSupport.getPersistenceManager().getPersistenceManagerFactory();
    }

    public Persistable_downloadJdoMetadata(Persistable persistable) {
        this.persistable = persistable;
    }

    public static class ActionDomainEvent
    extends CausewayModuleApplib.ActionDomainEvent<Persistable_downloadJdoMetadata> {
    }
}

