/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.identity.StringIdentity;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.IdStringifier;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class JdoStringIdentityValueSemantics
extends ValueSemanticsBasedOnIdStringifier<StringIdentity> {
    @Inject
    IdStringifier<String> idStringifierForString;

    public JdoStringIdentityValueSemantics() {
        super(StringIdentity.class);
    }

    JdoStringIdentityValueSemantics(IdStringifier<String> idStringifierForString) {
        this();
        this.idStringifierForString = idStringifierForString;
    }

    public ValueDecomposition decompose(StringIdentity value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldIdentity::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public StringIdentity compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull StringIdentity value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.idStringifierForString.enstring((Object)value.getKey());
    }

    public StringIdentity destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        String idValue = (String)this.idStringifierForString.destring(targetEntityClass, stringified);
        return new StringIdentity(targetEntityClass, idValue);
    }

    @Generated
    public static JdoStringIdentityValueSemanticsBuilder builder() {
        return new JdoStringIdentityValueSemanticsBuilder();
    }

    @Generated
    public static class JdoStringIdentityValueSemanticsBuilder {
        @Generated
        private IdStringifier<String> idStringifierForString;

        @Generated
        JdoStringIdentityValueSemanticsBuilder() {
        }

        @Generated
        public JdoStringIdentityValueSemanticsBuilder idStringifierForString(IdStringifier<String> idStringifierForString) {
            this.idStringifierForString = idStringifierForString;
            return this;
        }

        @Generated
        public JdoStringIdentityValueSemantics build() {
            return new JdoStringIdentityValueSemantics(this.idStringifierForString);
        }

        @Generated
        public String toString() {
            return "JdoStringIdentityValueSemantics.JdoStringIdentityValueSemanticsBuilder(idStringifierForString=" + this.idStringifierForString + ")";
        }
    }
}

