/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.entities;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnOidStoreAndRecoverHelper;
import org.apache.causeway.persistence.jdo.datanucleus.metamodel.facets.entity.JdoEntityFacet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.DataNucleusHelperJDO;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ReferentialStateManagerImpl;
import org.datanucleus.store.FieldValues;
import org.springframework.lang.Nullable;

public class DnStateManagerForCauseway
extends ReferentialStateManagerImpl {
    @Generated
    private static final Logger log = LogManager.getLogger(DnStateManagerForCauseway.class);
    private boolean injectionPointsResolved = false;
    private final _Refs.ObjectReference<PreDirtyPropagationLock> preDirtyPropagationLockRef = _Refs.objectRef(null);

    public DnStateManagerForCauseway(ExecutionContext ec, AbstractClassMetaData cmd) {
        super(ec, cmd);
    }

    public void initialiseForHollow(Object id, FieldValues fv, Class pcClass) {
        super.initialiseForHollow(id, fv, pcClass);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForHollowAppId(FieldValues fv, Class pcClass) {
        super.initialiseForHollowAppId(fv, pcClass);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForHollowPreConstructed(Object id, Persistable pc) {
        super.initialiseForHollowPreConstructed(id, pc);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForPersistentClean(Object id, Persistable pc) {
        super.initialiseForPersistentClean(id, pc);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForEmbedded(Persistable pc, boolean copyPc) {
        super.initialiseForEmbedded(pc, copyPc);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForPersistentNew(Persistable pc, FieldValues preInsertChanges) {
        super.initialiseForPersistentNew(pc, preInsertChanges);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForTransactionalTransient(Persistable pc) {
        super.initialiseForTransactionalTransient(pc);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForDetached(Persistable pc, Object id, Object version) {
        super.initialiseForDetached(pc, id, version);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForPNewToBeDeleted(Persistable pc) {
        super.initialiseForPNewToBeDeleted(pc);
        this.injectServicesIfNotAlready();
    }

    public void initialiseForCachedPC(CachedPC cachedPC, Object id) {
        super.initialiseForCachedPC(cachedPC, id);
        this.injectServicesIfNotAlready();
    }

    public void disconnect() {
        Persistable entityPojo = this.myPC;
        Optional<String> snapshotOid = this.snapshotOid();
        super.disconnect();
        snapshotOid.ifPresent(oid -> DnOidStoreAndRecoverHelper.forEntity(entityPojo).storeOid((String)oid));
    }

    public boolean isInsertingOrInsertingCallbacks() {
        return super.isInserting() || (this.flags & 0x200000) != 0;
    }

    public boolean injectServicesIfNotAlready() {
        if (this.myPC == null) {
            this.injectionPointsResolved = false;
            return true;
        }
        if (this.injectionPointsResolved) {
            return true;
        }
        MetaModelContext.instance().ifPresentOrElse(mmc -> {
            mmc.getServiceInjector().injectServicesInto((Object)this.myPC);
            this.injectionPointsResolved = true;
        }, () -> log.warn("cannot inject services into entity of type {}, as there is no ServiceInjector available", (Object)this.myPC.getClass()));
        return this.injectionPointsResolved;
    }

    private Optional<String> snapshotOid() {
        if (this.myID == null) {
            return Optional.empty();
        }
        try {
            Object id = this.myPC.dnGetObjectId();
            if (id == null) {
                return Optional.empty();
            }
            JdoEntityFacet entityFacet = this.lookupEntityFacet().orElse(null);
            if (entityFacet == null) {
                return Optional.empty();
            }
            if (id instanceof SingleFieldId) {
                id = DataNucleusHelperJDO.getSingleFieldIdentityForDataNucleusIdentity((SingleFieldId)((SingleFieldId)id), (Class)this.myPC.getClass());
            }
            Optional<String> oidIfAny = entityFacet.identifierForDnPrimaryKey(id);
            return oidIfAny;
        }
        catch (Exception e) {
            log.error("exception while trying to extract entity's current primary key", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<JdoEntityFacet> lookupEntityFacet() {
        if (this.myPC == null) {
            return Optional.empty();
        }
        Optional<JdoEntityFacet> entityFacet = MetaModelContext.instance().map(HasMetaModelContext::getSpecificationLoader).flatMap(specLoader -> specLoader.specForType(this.myPC.getClass())).flatMap(ObjectSpecification::entityFacet).flatMap(facet -> _Casts.castTo(JdoEntityFacet.class, (Object)facet));
        return entityFacet;
    }

    private final PreDirtyPropagationLock createPreDirtyPropagationLock() {
        return () -> this.preDirtyPropagationLockRef.set(null);
    }

    public Optional<PreDirtyPropagationLock> acquirePreDirtyPropagationLock(Object id) {
        Optional<PreDirtyPropagationLock> lockIfGranted;
        Optional<PreDirtyPropagationLock> optional = lockIfGranted = !Objects.equals(this.myID, id) || this.preDirtyPropagationLockRef.isNotNull() ? Optional.empty() : Optional.of((PreDirtyPropagationLock)this.preDirtyPropagationLockRef.set((Object)this.createPreDirtyPropagationLock()));
        if (log.isDebugEnabled()) {
            log.debug("acquirePreDirtyPropagationLock({}) -> {}", id, (Object)lockIfGranted.map(lock -> "GRANTED").orElse("DENIED"));
        }
        return lockIfGranted;
    }

    public static Optional<DnStateManagerForCauseway> extractFrom(@Nullable Persistable pojo) {
        return pojo != null ? _Casts.castTo(DnStateManagerForCauseway.class, (Object)pojo.dnGetStateManager()) : Optional.empty();
    }

    @FunctionalInterface
    public static interface PreDirtyPropagationLock {
        public void release();

        default public void releaseAfter(Runnable runnable) {
            try {
                runnable.run();
            }
            finally {
                this.release();
            }
        }
    }
}

