/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import jakarta.annotation.Priority;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.datanucleus.identity.ObjectId;
import org.datanucleus.identity.SingleFieldId;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class DnObjectIdValueSemantics
extends ValueSemanticsBasedOnIdStringifier<ObjectId> {
    private static final String PREFIX_UUID = "u_";
    private static final String PREFIX_LONG = "l_";
    private static final String PREFIX_INT = "i_";

    public DnObjectIdValueSemantics() {
        super(ObjectId.class);
    }

    public ValueDecomposition decompose(ObjectId value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldId::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public ObjectId compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull ObjectId value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Object keyAsObject = value.getKeyAsObject();
        if (keyAsObject instanceof Long) {
            return PREFIX_LONG + String.valueOf(keyAsObject);
        }
        if (keyAsObject instanceof Integer) {
            return PREFIX_INT + String.valueOf(keyAsObject);
        }
        if (keyAsObject instanceof UUID) {
            return PREFIX_UUID + String.valueOf(keyAsObject);
        }
        return keyAsObject.toString();
    }

    public ObjectId destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        if (stringified.startsWith(PREFIX_LONG)) {
            return new ObjectId(targetEntityClass, (Object)Long.parseLong(stringified.substring(PREFIX_LONG.length())));
        }
        if (stringified.startsWith(PREFIX_INT)) {
            return new ObjectId(targetEntityClass, (Object)Integer.parseInt(stringified.substring(PREFIX_INT.length())));
        }
        if (stringified.startsWith(PREFIX_UUID)) {
            return new ObjectId(targetEntityClass, (Object)UUID.fromString(stringified.substring(PREFIX_UUID.length())));
        }
        return new ObjectId(targetEntityClass, (Object)stringified);
    }

    @Generated
    public static DnObjectIdValueSemanticsBuilder builder() {
        return new DnObjectIdValueSemanticsBuilder();
    }

    @Generated
    public static class DnObjectIdValueSemanticsBuilder {
        @Generated
        DnObjectIdValueSemanticsBuilder() {
        }

        @Generated
        public DnObjectIdValueSemantics build() {
            return new DnObjectIdValueSemantics();
        }

        @Generated
        public String toString() {
            return "DnObjectIdValueSemantics.DnObjectIdValueSemanticsBuilder()";
        }
    }
}

