/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.persistencecapable;

import java.util.Optional;
import javax.inject.Inject;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.PersistenceCapable;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.facets.ObjectTypeFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacetFromAnnotation;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoPersistenceCapableFacetFactory
extends FacetFactoryAbstract
implements ObjectTypeFacetFactory {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoPersistenceCapableFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(ObjectTypeFacetFactory.ProcessObjectTypeContext processClassContext) {
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        if (!this.processJdoAnnotations(processClassContext)) {
            this.processJpaAnnotations(processClassContext);
        }
    }

    private boolean processJdoAnnotations(ObjectTypeFacetFactory.ProcessObjectTypeContext processClassContext) {
        Class cls = processClassContext.getCls();
        Optional persistenceCapableIfAny = processClassContext.synthesizeOnType(PersistenceCapable.class);
        if (!persistenceCapableIfAny.isPresent()) {
            return false;
        }
        Optional embeddedOnlyIfAny = processClassContext.synthesizeOnType(EmbeddedOnly.class);
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        return FacetUtil.addFacetIfPresent(JdoPersistenceCapableFacetFromAnnotation.createUsingJdo(persistenceCapableIfAny, embeddedOnlyIfAny, cls, facetHolder)).map(jdoPersistenceCapableFacet -> {
            FacetUtil.addFacet((Facet)this.jdoFacetContext.createEntityFacet(facetHolder, cls));
            return true;
        }).orElse(false);
    }

    private void processJpaAnnotations(ObjectTypeFacetFactory.ProcessObjectTypeContext processClassContext) {
        Optional entityIfAny = processClassContext.synthesizeOnType(Entity.class);
        if (!entityIfAny.isPresent()) {
            return;
        }
        Class cls = processClassContext.getCls();
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        Optional tableIfAny = processClassContext.synthesizeOnType(Table.class);
        FacetUtil.addFacetIfPresent(JdoPersistenceCapableFacetFromAnnotation.createUsingJpa(entityIfAny, tableIfAny, cls, facetHolder)).ifPresent(jdoPersistenceCapableFacet -> FacetUtil.addFacet((Facet)this.jdoFacetContext.createEntityFacet(facetHolder, cls)));
    }
}

