/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel;

import javax.jdo.annotations.IdentityType;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.collections.CollectionFacet;
import org.apache.causeway.core.metamodel.facets.object.ignore.datanucleus.RemoveDatanucleusPersistableTypesFacetFactory;
import org.apache.causeway.core.metamodel.facets.object.ignore.datanucleus.RemoveDnPrefixedMethodsFacetFactory;
import org.apache.causeway.core.metamodel.facets.object.ignore.jdo.RemoveJdoEnhancementTypesFacetFactory;
import org.apache.causeway.core.metamodel.facets.object.ignore.jdo.RemoveJdoPrefixedMethodsFacetFactory;
import org.apache.causeway.core.metamodel.facets.object.parented.ParentedCollectionFacet;
import org.apache.causeway.core.metamodel.progmodel.ProgrammingModel;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.datastoreidentity.JdoDatastoreIdentityAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.version.JdoVersionAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.BigDecimalFromJdoColumnAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MandatoryFromJdoColumnAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MaxLengthFromJdoColumnAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.primarykey.JdoPrimaryKeyAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.springframework.stereotype.Component;

@Component
public class JdoProgrammingModel
implements MetaModelRefiner {
    public void refineProgrammingModel(ProgrammingModel pm) {
        ProgrammingModel.FacetProcessingOrder step1 = ProgrammingModel.FacetProcessingOrder.C2_AFTER_METHOD_REMOVING;
        MetaModelContext mmc = pm.getMetaModelContext();
        pm.addFactory(step1, (FacetFactory)new RemoveJdoEnhancementTypesFacetFactory(mmc), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step1, (FacetFactory)new RemoveJdoPrefixedMethodsFacetFactory(mmc), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step1, (FacetFactory)new RemoveDatanucleusPersistableTypesFacetFactory(mmc), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step1, (FacetFactory)new RemoveDnPrefixedMethodsFacetFactory(mmc), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        ProgrammingModel.FacetProcessingOrder step2 = ProgrammingModel.FacetProcessingOrder.A2_AFTER_FALLBACK_DEFAULTS;
        JdoFacetContext jdoFacetContext = (JdoFacetContext)mmc.getServiceRegistry().lookupServiceElseFail(JdoFacetContext.class);
        pm.addFactory(step2, (FacetFactory)new JdoPersistenceCapableFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new JdoDatastoreIdentityAnnotationFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new JdoPrimaryKeyAnnotationFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new JdoNotPersistentAnnotationFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new JdoVersionAnnotationFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new JdoQueryAnnotationFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new BigDecimalFromJdoColumnAnnotationFacetFactory(mmc), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new MaxLengthFromJdoColumnAnnotationFacetFactory(mmc), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        pm.addFactory(step2, (FacetFactory)new MandatoryFromJdoColumnAnnotationFacetFactory(mmc, jdoFacetContext), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        this.addValidatorToEnsureIdentityType(pm);
        this.addValidatorToCheckForUnsupportedAnnotations(pm);
    }

    private void addValidatorToEnsureIdentityType(ProgrammingModel pm) {
        pm.addValidatorSkipManagedBeans(objSpec -> {
            JdoPersistenceCapableFacet jpcf = (JdoPersistenceCapableFacet)objSpec.getFacet(JdoPersistenceCapableFacet.class);
            if (jpcf == null) {
                return;
            }
            IdentityType identityType = jpcf.getIdentityType();
            if (identityType != IdentityType.APPLICATION && identityType != IdentityType.NONDURABLE && identityType != IdentityType.DATASTORE && identityType != IdentityType.UNSPECIFIED) {
                ValidationFailure.raiseFormatted((FacetHolder)objSpec, (String)"%s: is annotated with @PersistenceCapable but with an unrecognized identityType (%s)", (Object[])new Object[]{objSpec.getFullIdentifier(), identityType});
            }
        }, new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
    }

    private void addValidatorToCheckForUnsupportedAnnotations(ProgrammingModel pm) {
        pm.addValidatorSkipManagedBeans(objSpec -> {
            if (objSpec.containsNonFallbackFacet(ParentedCollectionFacet.class) && !objSpec.containsNonFallbackFacet(CollectionFacet.class)) {
                ValidationFailure.raiseFormatted((FacetHolder)objSpec, (String)"%s: JDO/DataNucleus object store currently does not supported Aggregated or EmbeddedOnly annotations", (Object[])new Object[]{objSpec.getFullIdentifier()});
            }
        }, new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
    }
}

