/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.query;

import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.query.JdoQueryFacet;

abstract class MetaModelValidatorForJdoqlAbstract
extends MetaModelValidatorAbstract {
    final String clause;

    protected MetaModelValidatorForJdoqlAbstract(MetaModelContext mmc, String clause) {
        super(mmc, SKIP_MANAGED_BEANS);
        this.clause = clause;
    }

    public void validateObjectEnter(ObjectSpecification objectSpec) {
        JdoQueryFacet jdoQueryFacet = (JdoQueryFacet)objectSpec.getFacet(JdoQueryFacet.class);
        if (jdoQueryFacet == null) {
            return;
        }
        for (JdoNamedQuery namedQuery : jdoQueryFacet.getNamedQueries()) {
            if (!namedQuery.getLanguage().equals("JDOQL")) continue;
            String query = namedQuery.getQuery();
            String fromClassName = this.deriveClause(query);
            this.interpretJdoql(fromClassName, objectSpec, query);
        }
    }

    private void interpretJdoql(String typeNameFromClause, ObjectSpecification objectSpec, String query) {
        if (_Strings.isNullOrEmpty((CharSequence)typeNameFromClause)) {
            return;
        }
        Class cls = objectSpec.getCorrespondingClass();
        Try fromSpecResult = Try.call(() -> this.getSpecificationLoader().specForType(_Context.loadClass((String)typeNameFromClause)).orElse(null));
        if (!fromSpecResult.getValue().isPresent()) {
            ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)LogicalType.fqcn((Class)cls)), (String)String.format("%s: error in JDOQL query, class name for '%s' clause not recognized (JDOQL : %s)", cls.getName(), this.clause, query));
            return;
        }
        this.postInterpretJdoql(typeNameFromClause, objectSpec, query);
    }

    abstract String deriveClause(String var1);

    abstract void postInterpretJdoql(String var1, ObjectSpecification var2, String var3);
}

