/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.spring.integration;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import javax.sql.DataSource;
import org.apache.causeway.persistence.jdo.spring.integration.DefaultJdoDialect;
import org.apache.causeway.persistence.jdo.spring.integration.JdoDialect;
import org.apache.causeway.persistence.jdo.spring.integration.PersistenceManagerFactoryUtils;
import org.apache.causeway.persistence.jdo.spring.integration.PersistenceManagerHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.DelegatingTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private PersistenceManagerFactory persistenceManagerFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private JdoDialect jdoDialect;

    public JdoTransactionManager() {
    }

    public JdoTransactionManager(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
        this.afterPropertiesSet();
    }

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public JdoDialect getJdoDialect() {
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect();
        }
        return this.jdoDialect;
    }

    public void afterPropertiesSet() {
        Object pmfcf;
        if (this.getPersistenceManagerFactory() == null) {
            throw new IllegalArgumentException("Property 'persistenceManagerFactory' is required");
        }
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect(this.getPersistenceManagerFactory().getConnectionFactory());
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (pmfcf = this.getPersistenceManagerFactory().getConnectionFactory()) instanceof DataSource) {
            this.dataSource = (DataSource)pmfcf;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + String.valueOf(this.dataSource) + "] of JDO PersistenceManagerFactory for JdoTransactionManager"));
            }
        }
    }

    public Object getResourceFactory() {
        return this.getPersistenceManagerFactory();
    }

    protected Object doGetTransaction() {
        JdoTransactionObject txObject = new JdoTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getPersistenceManagerFactory()));
        if (pmHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound PersistenceManager [" + String.valueOf(pmHolder.getPersistenceManager()) + "] for JDO transaction"));
            }
            txObject.setPersistenceManagerHolder(pmHolder, false);
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((JdoTransactionObject)((Object)transaction)).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        JdoTransactionObject txObject = (JdoTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! JdoTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JdoTransactionManager for all transactions on a single DataSource, no matter whether JDO or JDBC access.");
        }
        try {
            if (txObject.getPersistenceManagerHolder() == null || txObject.getPersistenceManagerHolder().isSynchronizedWithTransaction()) {
                PersistenceManager newPm = this.getPersistenceManagerFactory().getPersistenceManager();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new PersistenceManager [" + String.valueOf(newPm) + "] for JDO transaction"));
                }
                txObject.setPersistenceManagerHolder(new PersistenceManagerHolder(newPm), true);
            }
            PersistenceManager pm = txObject.getPersistenceManagerHolder().getPersistenceManager();
            final int timeoutToUse = this.determineTimeout(definition);
            Object transactionData = this.getJdoDialect().beginTransaction(pm.currentTransaction(), (TransactionDefinition)new DelegatingTransactionDefinition(definition){

                public int getTimeout() {
                    return timeoutToUse;
                }
            });
            txObject.setTransactionData(transactionData);
            if (timeoutToUse != -1) {
                txObject.getPersistenceManagerHolder().setTimeoutInSeconds(timeoutToUse);
            }
            if (this.getDataSource() != null) {
                ConnectionHandle conHandle = this.getJdoDialect().getJdbcConnection(pm, definition.isReadOnly());
                if (conHandle != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                    if (timeoutToUse != -1) {
                        conHolder.setTimeoutInSeconds(timeoutToUse);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Exposing JDO transaction as JDBC transaction [" + String.valueOf(conHolder.getConnectionHandle()) + "]"));
                    }
                    TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not exposing JDO transaction [" + String.valueOf(pm) + "] as JDBC transaction because JdoDialect [" + String.valueOf(this.getJdoDialect()) + "] does not support JDBC Connection retrieval"));
                }
            }
            if (txObject.isNewPersistenceManagerHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getPersistenceManagerFactory(), (Object)((Object)txObject.getPersistenceManagerHolder()));
            }
            txObject.getPersistenceManagerHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            this.closePersistenceManagerAfterFailedBegin(txObject);
            throw ex;
        }
        catch (Throwable ex) {
            this.closePersistenceManagerAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not open JDO PersistenceManager for transaction", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePersistenceManagerAfterFailedBegin(JdoTransactionObject txObject) {
        if (txObject.isNewPersistenceManagerHolder()) {
            PersistenceManager pm = txObject.getPersistenceManagerHolder().getPersistenceManager();
            try {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not rollback PersistenceManager after failed transaction begin", ex);
            }
            finally {
                PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
            }
            txObject.setPersistenceManagerHolder(null, false);
        }
    }

    protected Object doSuspend(Object transaction) {
        JdoTransactionObject txObject = (JdoTransactionObject)((Object)transaction);
        txObject.setPersistenceManagerHolder(null, false);
        PersistenceManagerHolder persistenceManagerHolder = (PersistenceManagerHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource((Object)this.getDataSource())) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(persistenceManagerHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource((Object)this.getPersistenceManagerFactory(), (Object)((Object)resourcesHolder.getPersistenceManagerHolder()));
        if (this.getDataSource() != null && resourcesHolder.getConnectionHolder() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JDO transaction on PersistenceManager [" + String.valueOf(txObject.getPersistenceManagerHolder().getPersistenceManager()) + "]"));
        }
        try {
            Transaction tx = txObject.getPersistenceManagerHolder().getPersistenceManager().currentTransaction();
            tx.commit();
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JDO transaction on PersistenceManager [" + String.valueOf(txObject.getPersistenceManagerHolder().getPersistenceManager()) + "]"));
        }
        try {
            Transaction tx = txObject.getPersistenceManagerHolder().getPersistenceManager().currentTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (JDOException ex) {
            throw new TransactionSystemException("Could not roll back JDO transaction", (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)((Object)status.getTransaction());
        PersistenceManager persistenceManager = txObject.getPersistenceManagerHolder().getPersistenceManager();
        if (persistenceManager.isClosed()) {
            this.logger.warn((Object)("Request to set JDO transaction on PersistenceManager [" + String.valueOf(persistenceManager) + "] rollback-only ignored; PM is closed"));
            return;
        }
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JDO transaction on PersistenceManager [" + String.valueOf(persistenceManager) + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JdoTransactionObject txObject = (JdoTransactionObject)((Object)transaction);
        if (txObject.isNewPersistenceManagerHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory());
        }
        txObject.getPersistenceManagerHolder().clear();
        if (txObject.hasConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
            try {
                this.getJdoDialect().releaseJdbcConnection(txObject.getConnectionHolder().getConnectionHandle(), txObject.getPersistenceManagerHolder().getPersistenceManager());
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not release JDBC connection after transaction", ex);
            }
        }
        this.getJdoDialect().cleanupTransaction(txObject.getTransactionData());
        if (txObject.isNewPersistenceManagerHolder()) {
            PersistenceManager pm = txObject.getPersistenceManagerHolder().getPersistenceManager();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing JDO PersistenceManager [" + String.valueOf(pm) + "] after transaction"));
            }
            PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
        } else {
            this.logger.debug((Object)"Not closing pre-bound JDO PersistenceManager after transaction");
        }
    }

    protected DataAccessException convertJdoAccessException(JDOException ex) {
        return this.getJdoDialect().translateException(ex);
    }

    private class JdoTransactionObject
    extends JdbcTransactionObjectSupport {
        private PersistenceManagerHolder persistenceManagerHolder;
        private boolean newPersistenceManagerHolder;
        private Object transactionData;

        private JdoTransactionObject() {
        }

        public void setPersistenceManagerHolder(PersistenceManagerHolder persistenceManagerHolder, boolean newPersistenceManagerHolder) {
            this.persistenceManagerHolder = persistenceManagerHolder;
            this.newPersistenceManagerHolder = newPersistenceManagerHolder;
        }

        public PersistenceManagerHolder getPersistenceManagerHolder() {
            return this.persistenceManagerHolder;
        }

        public boolean isNewPersistenceManagerHolder() {
            return this.newPersistenceManagerHolder;
        }

        public boolean hasTransaction() {
            return this.persistenceManagerHolder != null && this.persistenceManagerHolder.isTransactionActive();
        }

        public void setTransactionData(Object transactionData) {
            this.transactionData = transactionData;
            this.persistenceManagerHolder.setTransactionActive(true);
        }

        public Object getTransactionData() {
            return this.transactionData;
        }

        public void setRollbackOnly() {
            Transaction tx = this.persistenceManagerHolder.getPersistenceManager().currentTransaction();
            if (tx.isActive()) {
                tx.setRollbackOnly();
            }
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            Transaction tx = this.persistenceManagerHolder.getPersistenceManager().currentTransaction();
            return tx.getRollbackOnly();
        }

        public void flush() {
            try {
                this.persistenceManagerHolder.getPersistenceManager().flush();
            }
            catch (JDOException ex) {
                throw JdoTransactionManager.this.convertJdoAccessException(ex);
            }
        }
    }

    private static class SuspendedResourcesHolder {
        private final PersistenceManagerHolder persistenceManagerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(PersistenceManagerHolder pmHolder, ConnectionHolder conHolder) {
            this.persistenceManagerHolder = pmHolder;
            this.connectionHolder = conHolder;
        }

        private PersistenceManagerHolder getPersistenceManagerHolder() {
            return this.persistenceManagerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

