/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.fixtures.applib.personas;

import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.causeway.testing.fixtures.applib.personas.PersonaWithBuilderScript;
import org.apache.causeway.testing.fixtures.applib.personas.PersonaWithFinder;

public abstract class BuilderScriptAbstract<T>
extends FixtureScript
implements FixtureScriptWithExecutionStrategy {
    private final FixtureScripts.MultipleExecutionStrategy multipleExecutionStrategy;

    protected BuilderScriptAbstract() {
        this(FixtureScripts.MultipleExecutionStrategy.EXECUTE_ONCE_BY_VALUE);
    }

    protected BuilderScriptAbstract(FixtureScripts.MultipleExecutionStrategy executionStrategy) {
        this.multipleExecutionStrategy = executionStrategy;
    }

    public abstract T getObject();

    @Programmatic
    public BuilderScriptAbstract<T> build(FixtureScript parentFixtureScript, FixtureScript.ExecutionContext executionContext) {
        parentFixtureScript.getServiceInjector().injectServicesInto((Object)this);
        return executionContext.executeChildT(parentFixtureScript, this);
    }

    public <P extends PersonaWithBuilderScript<X, B>, X, B extends BuilderScriptAbstract<X>> X objectFor(P persona, FixtureScript.ExecutionContext ec) {
        if (persona == null) {
            return null;
        }
        B fixtureScript = persona.builder();
        return (X)((BuilderScriptAbstract)ec.executeChildT((FixtureScript)this, fixtureScript)).getObject();
    }

    public <P extends PersonaWithFinder<X>, X> X findUsing(P persona) {
        if (persona == null) {
            return null;
        }
        return persona.findUsing(this.serviceRegistry);
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.multipleExecutionStrategy;
    }
}

