/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.fixtures.applib.fixturescripts;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.ViewModel;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.Domain;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.services.eventbus.EventBusService;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.applib.services.jaxb.JaxbService;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.applib.services.title.TitleService;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.testing.fixtures.applib.events.FixturesInstalledEvent;
import org.apache.causeway.testing.fixtures.applib.events.FixturesInstallingEvent;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.ExecutionParameters;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.ExecutionParametersService;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.ExecutionParametersServiceAutoConfiguration;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureResult;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecification;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecificationProvider;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecificationProviderAutoConfiguration;
import org.apache.causeway.testing.fixtures.applib.personas.BuilderScriptAbstract;
import org.apache.causeway.testing.fixtures.applib.personas.PersonaWithBuilderScript;
import org.springframework.context.annotation.Import;

@DomainService
@Named(value="causeway.testing.fixtures.FixtureScripts")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Import(value={FixtureScriptsSpecificationProviderAutoConfiguration.class, ExecutionParametersServiceAutoConfiguration.class})
@Priority(value=0x1FFFFFFF)
public class FixtureScripts {
    public static final String LOGICAL_TYPE_NAME = "causeway.testing.fixtures.FixtureScripts";
    @Inject
    private TitleService titleService;
    @Inject
    private JaxbService jaxbService;
    @Inject
    private ServiceInjector serviceInjector;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private TransactionService transactionService;
    @Inject
    private ExecutionParametersService executionParametersService;
    @Inject
    private InteractionService interactionService;
    @Inject
    private EventBusService eventBusService;
    private final FixtureScriptsSpecification specification;
    private final NonPersistedObjectsStrategy nonPersistedObjectsStrategy;
    private final MultipleExecutionStrategy multipleExecutionStrategy;
    private final SortedMap<String, FixtureScript> fixtureScriptByFriendlyName;

    @Inject
    public FixtureScripts(FixtureScriptsSpecificationProvider fixtureScriptsSpecificationProvider, ServiceRegistry serviceRegistry) {
        this.specification = fixtureScriptsSpecificationProvider.getSpecification();
        this.nonPersistedObjectsStrategy = this.specification.getNonPersistedObjectsStrategy();
        this.multipleExecutionStrategy = this.specification.getMultipleExecutionStrategy();
        String packagePrefix = this.specification.getPackagePrefix();
        this.fixtureScriptByFriendlyName = packagePrefix != null ? (SortedMap)serviceRegistry.select(FixtureScript.class).stream().filter(Objects::nonNull).filter(fixtureScript -> fixtureScript.getClass().getPackage().getName().startsWith(packagePrefix)).collect(Collectors.toMap(FixtureScript::getFriendlyName, Function.identity(), (v1, v2) -> {
            throw new RuntimeException(String.format("Two FixtureScript's have the same friendly name '%s", v1));
        }, TreeMap::new)) : _Maps.newTreeMap();
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa fa-chevron-right", sequence="10")
    public List<FixtureResult> runFixtureScript(@ParameterLayout(named="Fixture script") String fixtureScriptName, @ParameterLayout(named="Parameters", describedAs="Script-specific parameters (if any).  The format depends on the script implementation (eg key=value, CSV, JSON, XML etc)", multiLine=10) @Parameter(optionality=Optionality.OPTIONAL) String parameters) {
        FixtureScript fixtureScript = (FixtureScript)this.fixtureScriptByFriendlyName.get(fixtureScriptName);
        return this.runFixtureScript(fixtureScript, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public List<FixtureResult> runFixtureScript(FixtureScript fixtureScript, String parameters) {
        try {
            this.eventBusService.post((Object)new FixturesInstallingEvent(this));
            this.serviceInjector.injectServicesInto((Object)fixtureScript);
            List<FixtureResult> list = fixtureScript.run(parameters, this);
            return list;
        }
        finally {
            this.eventBusService.post((Object)new FixturesInstalledEvent(this));
        }
    }

    @MemberSupport
    public boolean hideRunFixtureScript() {
        return this.specification == null;
    }

    @MemberSupport
    public String disableRunFixtureScript() {
        return this.getFixtureScriptByFriendlyName().isEmpty() ? String.format("No fixture scripts found under package '%s'", this.specification.getPackagePrefix()) : null;
    }

    @MemberSupport
    public String default0RunFixtureScript() {
        String defaultFixtureScript = this.defaultFromFixtureScriptsSpecification();
        if (defaultFixtureScript != null) {
            return defaultFixtureScript;
        }
        Set<String> choices = this.choices0RunFixtureScript();
        return choices.size() == 1 ? choices.iterator().next() : null;
    }

    @Domain.Exclude
    private String defaultFromFixtureScriptsSpecification() {
        Class<? extends FixtureScript> defaultScript = this.specification.getRunScriptDefaultScriptClass();
        return defaultScript != null ? this.findFixtureScriptNameFor(defaultScript) : null;
    }

    @MemberSupport
    public Set<String> choices0RunFixtureScript() {
        return this.fixtureScriptByFriendlyName.keySet();
    }

    @MemberSupport
    public String validateRunFixtureScript(String fixtureScriptName, String parameters) {
        return ((FixtureScript)this.fixtureScriptByFriendlyName.get(fixtureScriptName)).validateRun(parameters);
    }

    protected List<FixtureResult> runScript(String fixtureScriptName, String parameters) {
        FixtureScript fixtureScript = (FixtureScript)this.fixtureScriptByFriendlyName.get(fixtureScriptName);
        return this.runScript(fixtureScript, parameters);
    }

    protected List<FixtureResult> runScript(FixtureScript fixtureScript, String parameters) {
        this.serviceInjector.injectServicesInto((Object)fixtureScript);
        return fixtureScript.run(parameters, this);
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa fa-sync", sequence="20")
    public Object recreateObjectsAndReturnFirst() {
        Class<? extends FixtureScript> recreateScriptClass = this.getSpecification().getRecreateScriptClass();
        String recreateScript = this.findFixtureScriptNameFor(recreateScriptClass);
        if (recreateScript == null) {
            return null;
        }
        List<FixtureResult> results = this.runScript(recreateScript, null);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0).getObject();
    }

    @MemberSupport
    public boolean hideRecreateObjectsAndReturnFirst() {
        return this.specification == null || this.specification.getRecreateScriptClass() == null;
    }

    @Programmatic
    public void run(FixtureScript ... fixtureScriptList) {
        FixtureScript singleScript = FixtureScripts.toSingleScript(fixtureScriptList);
        String parameters = null;
        this.interactionService.runAnonymous(() -> this.transactionService.runWithinCurrentTransactionElseCreateNew(() -> this.runScript(singleScript, parameters)));
    }

    @SafeVarargs
    @Programmatic
    public final void runPersonas(final PersonaWithBuilderScript<?, ? extends BuilderScriptAbstract<?>> ... personas) {
        ((Try)this.interactionService.callAnonymous(() -> this.transactionService.callWithinCurrentTransactionElseCreateNew(() -> this.runFixtureScript(new FixtureScript(){

            @Override
            protected void execute(FixtureScript.ExecutionContext executionContext) {
                for (PersonaWithBuilderScript personaWithBuilderScript : personas) {
                    Object fixtureScript = personaWithBuilderScript.builder();
                    executionContext.executeChild((FixtureScript)this, (FixtureScript)fixtureScript);
                }
            }
        }, null)))).ifFailureFail();
    }

    @Programmatic
    public <T> T runPersona(PersonaWithBuilderScript<T, ? extends BuilderScriptAbstract<? extends T>> persona) {
        BuilderScriptAbstract<? extends T> fixtureScript = persona.builder();
        return this.runBuilder(fixtureScript);
    }

    @Programmatic
    public <T> T runBuilder(BuilderScriptAbstract<T> builderScript) {
        return ((Try)this.interactionService.callAnonymous(() -> this.transactionService.callWithinCurrentTransactionElseCreateNew(() -> this.runBuilderScriptNonTransactional(builderScript)))).ifFailureFail().getValue().orElse(null);
    }

    @Programmatic
    public <T> T runBuilderScriptNonTransactional(BuilderScriptAbstract<T> builderScript) {
        this.serviceInjector.injectServicesInto(builderScript);
        builderScript.run(null, this);
        T object = builderScript.getObject();
        return object;
    }

    @Programmatic
    protected String findFixtureScriptNameFor(Class<? extends FixtureScript> fixtureScriptClass) {
        Set<Map.Entry<String, FixtureScript>> fixtureScripts = this.getFixtureScriptByFriendlyName().entrySet();
        for (Map.Entry<String, FixtureScript> fs : fixtureScripts) {
            if (!fixtureScriptClass.isAssignableFrom(fs.getValue().getClass())) continue;
            return fs.getKey();
        }
        return null;
    }

    @Programmatic
    protected FixtureScript.ExecutionContext newExecutionContext(String parameters) {
        ExecutionParameters executionParameters = this.executionParametersService.newExecutionParameters(parameters);
        return FixtureScript.ExecutionContext.create(executionParameters, this);
    }

    @Programmatic
    FixtureResult newFixtureResult(FixtureScript script, String subkey, Object object, boolean firstTime) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof ViewModel) && !this.repositoryService.getEntityState(object).isAttachedOrRemoved()) {
            switch (this.getNonPersistedObjectsStrategy().ordinal()) {
                case 0: {
                    this.transactionService.flushTransaction();
                    break;
                }
                case 1: {
                    return null;
                }
                default: {
                    throw _Exceptions.unmatchedCase((Object)((Object)this.getNonPersistedObjectsStrategy()));
                }
            }
        }
        FixtureResult fixtureResult = (FixtureResult)this.serviceInjector.injectServicesInto((Object)new FixtureResult());
        fixtureResult.setFixtureScriptClassName(firstTime ? script.getClass().getName() : null);
        fixtureResult.setFixtureScriptQualifiedName(script.getQualifiedName());
        fixtureResult.setKey(script.pathWith(subkey));
        fixtureResult.setObject(object);
        return fixtureResult;
    }

    @Programmatic
    String titleOf(FixtureResult fixtureResult) {
        Object object = fixtureResult.getObject();
        return object != null ? this.titleService.titleOf(object) : "(null)";
    }

    private static FixtureScript toSingleScript(final FixtureScript[] fixtureScriptList) {
        if (fixtureScriptList.length == 1) {
            return fixtureScriptList[0];
        }
        return new FixtureScript(){

            @Override
            protected void execute(FixtureScript.ExecutionContext executionContext) {
                for (FixtureScript fixtureScript : fixtureScriptList) {
                    executionContext.executeChild((FixtureScript)this, fixtureScript);
                }
            }
        };
    }

    @Generated
    public FixtureScriptsSpecification getSpecification() {
        return this.specification;
    }

    @Programmatic
    @Generated
    public NonPersistedObjectsStrategy getNonPersistedObjectsStrategy() {
        return this.nonPersistedObjectsStrategy;
    }

    @Programmatic
    @Generated
    public MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.multipleExecutionStrategy;
    }

    @Generated
    public SortedMap<String, FixtureScript> getFixtureScriptByFriendlyName() {
        return this.fixtureScriptByFriendlyName;
    }

    public static enum NonPersistedObjectsStrategy {
        PERSIST,
        IGNORE;

    }

    public static enum MultipleExecutionStrategy {
        EXECUTE_ONCE_BY_CLASS,
        EXECUTE_ONCE_BY_VALUE,
        EXECUTE;


        public boolean isExecuteOnceByClass() {
            return this == EXECUTE_ONCE_BY_CLASS;
        }

        public boolean isExecuteOnceByValue() {
            return this == EXECUTE_ONCE_BY_VALUE;
        }

        public boolean isExecute() {
            return this == EXECUTE;
        }
    }
}

