/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.fixtures.applib.teardown.jdo;

import jakarta.inject.Inject;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.metadata.DiscriminatorMetadata;
import javax.jdo.metadata.InheritanceMetadata;
import javax.jdo.metadata.TypeMetadata;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.persistence.jdo.applib.services.JdoSupportService;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;

@Programmatic
public abstract class TeardownFixtureJdoAbstract
extends FixtureScript {
    @Inject
    private JdoSupportService jdoSupport;

    protected void deleteFrom(Class<?> cls) {
        this.preDeleteFrom(cls);
        String value = this.discriminatorValueOf(cls);
        if (value == null) {
            TypeMetadata metadata = this.jdoSupport.getPersistenceManager().getPersistenceManagerFactory().getMetadata(cls.getName());
            if (metadata == null) {
                this.deleteFrom(cls.getSimpleName());
            } else {
                String schema = metadata.getSchema();
                String table = metadata.getTable();
                if (_Strings.isNullOrEmpty((CharSequence)table)) {
                    table = cls.getSimpleName();
                }
                if (_Strings.isNullOrEmpty((CharSequence)schema)) {
                    this.deleteFrom(table);
                } else {
                    this.deleteFrom(schema, table);
                }
            }
        } else {
            String column = this.discriminatorColumnOf(cls);
            String schema = this.schemaOf(cls);
            String table = this.tableOf(cls);
            this.deleteFromWhere(schema, table, column, value);
        }
        this.postDeleteFrom(cls);
    }

    protected void preDeleteFrom(Class<?> cls) {
    }

    protected void postDeleteFrom(Class<?> cls) {
    }

    protected Integer deleteFrom(String schema, String table) {
        if (_Strings.isNullOrEmpty((CharSequence)schema)) {
            return this.deleteFrom(table);
        }
        return this.jdoSupport.executeUpdate(String.format("DELETE FROM \"%s\".\"%s\"", schema, table));
    }

    protected Integer deleteFrom(String table) {
        return this.jdoSupport.executeUpdate(String.format("DELETE FROM \"%s\"", table));
    }

    protected Integer deleteFromWhere(String schema, String table, String column, String value) {
        if (_Strings.isNullOrEmpty((CharSequence)schema)) {
            return this.deleteFromWhere(table, column, value);
        }
        String sql = String.format("DELETE FROM \"%s\".\"%s\" WHERE \"%s\"='%s'", schema, table, column, value);
        return this.jdoSupport.executeUpdate(sql);
    }

    protected Integer deleteFromWhere(String table, String column, String value) {
        String sql = String.format("DELETE FROM \"%s\" WHERE \"%s\"='%s'", table, column, value);
        return this.jdoSupport.executeUpdate(sql);
    }

    private String schemaOf(Class<?> cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return null;
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata != null && inheritanceMetadata.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.schemaOf(cls.getSuperclass());
        }
        return metadata.getSchema();
    }

    private String tableOf(Class<?> cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return cls.getSimpleName();
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata != null && inheritanceMetadata.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.tableOf(cls.getSuperclass());
        }
        String table = metadata.getTable();
        return !_Strings.isNullOrEmpty((CharSequence)table) ? table : cls.getSimpleName();
    }

    private String discriminatorValueOf(Class<?> cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return null;
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata == null || inheritanceMetadata.getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) {
            return null;
        }
        DiscriminatorMetadata discriminatorMetadata = inheritanceMetadata.getDiscriminatorMetadata();
        if (discriminatorMetadata == null || discriminatorMetadata.getStrategy() != DiscriminatorStrategy.VALUE_MAP) {
            return null;
        }
        return discriminatorMetadata.getValue();
    }

    private String discriminatorColumnOf(Class<?> cls) {
        String discriminator = this.doDiscriminatorOf(cls);
        return discriminator != null ? discriminator : "discriminator";
    }

    private String doDiscriminatorOf(Class<?> cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return null;
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata == null || inheritanceMetadata.getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) {
            return null;
        }
        DiscriminatorMetadata discriminatorMetadata = inheritanceMetadata.getDiscriminatorMetadata();
        if (discriminatorMetadata == null || discriminatorMetadata.getStrategy() != DiscriminatorStrategy.VALUE_MAP) {
            return null;
        }
        return discriminatorMetadata.getColumn();
    }

    private PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoSupport.getPersistenceManager().getPersistenceManagerFactory();
    }
}

