/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.h2console.ui.webmodule;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import lombok.Generated;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.datasources.DataSourceIntrospectionService;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.core.security.authentication.standard.RandomCodeGenerator;
import org.apache.causeway.core.webapp.modules.WebModuleAbstract;
import org.apache.causeway.core.webapp.modules.WebModuleContext;
import org.apache.causeway.testing.h2console.ui.webmodule.H2WebServerWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.H2WebServletForJakarta;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.test.WebModuleH2Console")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="H2Console")
public class WebModuleH2Console
extends WebModuleAbstract {
    @Generated
    private static final Logger log = LogManager.getLogger(WebModuleH2Console.class);
    private static final String SERVLET_NAME = "H2Console";
    private static final String CONSOLE_PATH = "/db";
    private final LocalResourcePath localResourcePathIfEnabled;
    private final CausewaySystemEnvironment causewaySystemEnvironment;
    private final boolean applicable;
    private final String name = "H2Console";

    @Inject
    public WebModuleH2Console(DataSourceIntrospectionService datasourceIntrospector, CausewaySystemEnvironment causewaySystemEnvironment, ServiceInjector serviceInjector) {
        super(serviceInjector);
        this.causewaySystemEnvironment = causewaySystemEnvironment;
        this.applicable = this.isPrototyping() && this.isH2MemConnectionUsed(datasourceIntrospector);
        this.localResourcePathIfEnabled = this.applicable ? new LocalResourcePath(CONSOLE_PATH) : null;
    }

    public Can<ServletContextListener> init(ServletContext ctx) throws ServletException {
        this.registerServlet(ctx, SERVLET_NAME, H2WebServlet.class).ifPresent(servletReg -> servletReg.addMapping(new String[]{"/db/*"}));
        return Can.empty();
    }

    public boolean isApplicable(WebModuleContext ctx) {
        return this.applicable;
    }

    private boolean isPrototyping() {
        return this.causewaySystemEnvironment.getDeploymentType().isPrototyping();
    }

    private boolean isH2MemConnectionUsed(DataSourceIntrospectionService datasourceIntrospector) {
        return datasourceIntrospector.getDataSourceInfos().stream().map(DataSourceIntrospectionService.DataSourceInfo::jdbcUrl).anyMatch(jdbcUrl -> {
            if (jdbcUrl.contains(":h2:mem:")) {
                log.info("found h2 in-memory data-source: {}", jdbcUrl);
                H2WebServlet.configure(jdbcUrl);
                return true;
            }
            return false;
        });
    }

    @Generated
    public LocalResourcePath getLocalResourcePathIfEnabled() {
        return this.localResourcePathIfEnabled;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    public static class H2WebServlet
    extends H2WebServletForJakarta {
        private static final long serialVersionUID = 1L;
        private static String jdbcUrl;
        @Inject
        private CausewayConfiguration causewayConfiguration;
        @Inject
        private RandomCodeGenerator randomCodeGenerator;

        @Override
        public void init() {
            super.init();
            if (_Strings.isEmpty((CharSequence)jdbcUrl)) {
                return;
            }
            DataSourceProperties dataSourceProperties = new DataSourceProperties();
            dataSourceProperties.setUsername("sa");
            dataSourceProperties.setUrl(jdbcUrl);
            ConnectionInfo connectionInfo = new ConnectionInfo(String.format("Generic Spring Datasource|%s|%s|%s", dataSourceProperties.determineDriverClassName(), dataSourceProperties.determineUrl(), dataSourceProperties.determineUsername()));
            H2WebServlet webServlet = this;
            H2WebServerWrapper.withH2WebServerWrapperDo(webServlet, h2WebServerWrapper -> {
                h2WebServerWrapper.setConnectionInfo(connectionInfo);
                h2WebServerWrapper.setAllowOthers(this.isWebAllowRemoteAccess());
                if (this.isGenerateRandomWebAdminPassword()) {
                    String webAdminPass = this.randomCodeGenerator.generateRandomCode(20);
                    log.info("webAdminPass: {}", (Object)webAdminPass);
                    h2WebServerWrapper.setAdminPassword(webAdminPass);
                }
            });
        }

        public static void configure(String jdbcUrl) {
            H2WebServlet.jdbcUrl = jdbcUrl;
        }

        private boolean isWebAllowRemoteAccess() {
            return this.causewayConfiguration.getPrototyping().getH2Console().isWebAllowRemoteAccess();
        }

        private boolean isGenerateRandomWebAdminPassword() {
            return this.causewayConfiguration.getPrototyping().getH2Console().isGenerateRandomWebAdminPassword();
        }
    }
}

