/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.dom.pojo;

import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.commons.internal.collections._Lists;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.opentest4j.AssertionFailedError;

public class PojoTester {
    private final Map<Class<?>, DatumFactory<?>> dataByType = new HashMap();

    public static PojoTester create() {
        return new PojoTester();
    }

    protected PojoTester() {
        DatumFactoryImpl<Boolean> booleanDatumFactory = new DatumFactoryImpl<Boolean>(Boolean.class, new Boolean[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Boolean getNext() {
                return this.counter.getAndIncrement() == 0;
            }
        };
        this.usingData((Class<?>)Boolean.TYPE, booleanDatumFactory);
        this.usingData(Boolean.class, booleanDatumFactory);
        DatumFactoryImpl<Byte> byteDatumFactory = new DatumFactoryImpl<Byte>(Byte.class, new Byte[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Byte getNext() {
                return (byte)this.counter.getAndIncrement();
            }
        };
        this.usingData((Class<?>)Byte.TYPE, byteDatumFactory);
        this.usingData(Byte.class, byteDatumFactory);
        DatumFactoryImpl<Short> shortDatumFactory = new DatumFactoryImpl<Short>(Short.class, new Short[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Short getNext() {
                return (short)this.counter.getAndIncrement();
            }
        };
        this.usingData((Class<?>)Short.TYPE, shortDatumFactory);
        this.usingData(Short.class, shortDatumFactory);
        DatumFactoryImpl<Character> charDatumFactory = new DatumFactoryImpl<Character>(Character.class, new Character[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Character getNext() {
                return Character.valueOf((char)this.counter.getAndIncrement());
            }
        };
        this.usingData((Class<?>)Character.TYPE, charDatumFactory);
        this.usingData(Character.class, charDatumFactory);
        DatumFactoryImpl<Integer> intDatumFactory = new DatumFactoryImpl<Integer>(Integer.class, new Integer[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Integer getNext() {
                return this.counter.getAndIncrement();
            }
        };
        this.usingData((Class<?>)Integer.TYPE, intDatumFactory);
        this.usingData(Integer.class, intDatumFactory);
        DatumFactoryImpl<Long> longDatumFactory = new DatumFactoryImpl<Long>(Long.class, new Long[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Long getNext() {
                return this.counter.getAndIncrement();
            }
        };
        this.usingData((Class<?>)Long.TYPE, longDatumFactory);
        this.usingData(Long.class, longDatumFactory);
        DatumFactoryImpl<Float> floatDatumFactory = new DatumFactoryImpl<Float>(Float.class, new Float[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Float getNext() {
                return Float.valueOf(this.counter.getAndIncrement());
            }
        };
        this.usingData((Class<?>)Float.TYPE, floatDatumFactory);
        this.usingData(Float.class, floatDatumFactory);
        DatumFactoryImpl<Double> doubleDatumFactory = new DatumFactoryImpl<Double>(Double.class, new Double[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Double getNext() {
                return this.counter.getAndIncrement();
            }
        };
        this.usingData((Class<?>)Double.TYPE, doubleDatumFactory);
        this.usingData(Double.class, doubleDatumFactory);
        this.usingData(new DatumFactoryImpl<String>(String.class, new String[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public String getNext() {
                return "string" + this.counter.getAndIncrement();
            }
        });
        this.usingData(new DatumFactoryImpl<BigDecimal>(BigDecimal.class, new BigDecimal[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public BigDecimal getNext() {
                return new BigDecimal(this.counter.getAndIncrement());
            }
        });
        this.usingData(new DatumFactoryImpl<BigInteger>(BigInteger.class, new BigInteger[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public BigInteger getNext() {
                return BigInteger.valueOf(this.counter.getAndIncrement());
            }
        });
        this.usingData(new DatumFactoryImpl<Date>(Date.class, new Date[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Date getNext() {
                return new Date(this.counter.getAndIncrement());
            }
        });
        this.usingData(new DatumFactoryImpl<Timestamp>(Timestamp.class, new Timestamp[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Timestamp getNext() {
                return new Timestamp(this.counter.getAndIncrement());
            }
        });
        this.usingData(new DatumFactoryImpl<Pattern>(Pattern.class, new Pattern[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public Pattern getNext() {
                return Pattern.compile("p" + this.counter.getAndIncrement());
            }
        });
        this.usingData(new DatumFactoryImpl<File>(File.class, new File[0]){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger();
            }

            @Override
            public File getNext() {
                return new File("file" + this.counter.getAndIncrement());
            }
        });
        DatumFactoryImpl listDatumFactory = new DatumFactoryImpl<List<?>>(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public List<?> getNext() {
                ArrayList<CallSite> list = new ArrayList<CallSite>();
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                return list;
            }
        };
        this.usingData(Iterable.class, listDatumFactory);
        this.usingData(Collection.class, listDatumFactory);
        this.usingData(List.class, listDatumFactory);
        this.usingData(new DatumFactoryImpl<Set<?>>(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Set<?> getNext() {
                HashSet<CallSite> list = new HashSet<CallSite>();
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                return list;
            }
        });
        this.usingData(new DatumFactoryImpl<SortedSet<?>>(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public SortedSet<?> getNext() {
                TreeSet<CallSite> list = new TreeSet<CallSite>();
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                list.add((CallSite)((Object)("element" + this.counter.getAndIncrement())));
                return list;
            }
        });
        this.usingData(new DatumFactoryImpl<byte[]>(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public byte[] getNext() {
                return new byte[]{(byte)this.counter.getAndIncrement()};
            }
        });
        this.usingData(new DatumFactoryImpl<char[]>(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public char[] getNext() {
                return new char[]{(char)this.counter.getAndIncrement()};
            }
        });
        this.usingData(Blob.class, new Blob("foo", "application/pdf", new byte[]{1, 2, 3}), new Blob("bar", "application/docx", new byte[]{4, 5}), new Blob("baz", "application/xlsx", new byte[]{7, 8, 9, 0}));
        this.usingData(Clob.class, new Clob("foo", "text/html", "<html/>".toCharArray()), new Clob("bar", "text/plain", "hello world".toCharArray()), new Clob("baz", "text/ini", "foo=bar".toCharArray()));
        this.usingData(java.time.LocalTime.class, java.time.LocalTime.of(11, 15), java.time.LocalTime.of(12, 20), java.time.LocalTime.of(13, 30), java.time.LocalTime.of(14, 45));
        this.usingData(LocalDate.class, LocalDate.of(2012, 7, 19), LocalDate.of(2012, 7, 20), LocalDate.of(2012, 8, 19), LocalDate.of(2013, 7, 19));
        this.usingData(LocalDateTime.class, LocalDateTime.of(2012, 7, 19, 11, 15), LocalDateTime.of(2012, 7, 20, 12, 20), LocalDateTime.of(2012, 8, 19, 13, 30), LocalDateTime.of(2013, 7, 19, 14, 45));
        this.usingData(OffsetDateTime.class, OffsetDateTime.of(2012, 7, 19, 11, 15, 0, 0, ZoneOffset.UTC), OffsetDateTime.of(2012, 7, 20, 12, 20, 0, 0, ZoneOffset.UTC), OffsetDateTime.of(2012, 8, 19, 13, 30, 0, 0, ZoneOffset.UTC), OffsetDateTime.of(2013, 7, 19, 14, 45, 0, 0, ZoneOffset.UTC));
        this.usingData(org.joda.time.LocalDate.class, new org.joda.time.LocalDate(2012, 7, 19), new org.joda.time.LocalDate(2012, 7, 20), new org.joda.time.LocalDate(2012, 8, 19), new org.joda.time.LocalDate(2013, 7, 19));
        this.usingData(LocalTime.class, new LocalTime(7, 19, 11, 15), new LocalTime(7, 20, 12, 20), new LocalTime(8, 19, 13, 30), new LocalTime(7, 19, 14, 45));
        this.usingData(org.joda.time.LocalDateTime.class, new org.joda.time.LocalDateTime(2012, 7, 19, 11, 15), new org.joda.time.LocalDateTime(2012, 7, 20, 12, 20), new org.joda.time.LocalDateTime(2012, 8, 19, 13, 30), new org.joda.time.LocalDateTime(2013, 7, 19, 14, 45));
        this.usingData(DateTime.class, new DateTime(2012, 7, 19, 11, 15), new DateTime(2012, 7, 20, 12, 20), new DateTime(2012, 8, 19, 13, 30), new DateTime(2013, 7, 19, 14, 45));
    }

    public <T> PojoTester usingData(DatumFactory<T> factory) {
        this.dataByType.put(factory.getType(), factory);
        return this;
    }

    <T> PojoTester usingData(Class<?> type, DatumFactory<T> factory) {
        this.dataByType.put(type, factory);
        return this;
    }

    public <T> PojoTester usingData(Class<T> c, T ... data) {
        if (Enum.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("No need to provide test data for enums");
        }
        if (data == null || data.length < 2) {
            throw new IllegalArgumentException("Test data is mandatory, at least two data items are required");
        }
        return this.usingData(new DatumFactoryImpl<T>(c, data));
    }

    public <T> PojoTester usingData(Class<T> c, List<T> data) {
        return this.usingData(new DatumFactoryImpl<T>(c, data));
    }

    public <T> PojoTester usingData(Class<T> compileTimeType, Class<? extends T> runtimeType) {
        Constructor<T> declaredConstructor = runtimeType.getDeclaredConstructor(new Class[0]);
        T obj1 = declaredConstructor.newInstance(new Object[0]);
        T obj2 = declaredConstructor.newInstance(new Object[0]);
        T obj3 = declaredConstructor.newInstance(new Object[0]);
        return this.usingData(compileTimeType, obj1, obj2, obj3);
    }

    public <T> PojoTester usingData(Class<T> compileTimeType) {
        return this.usingData(compileTimeType, compileTimeType);
    }

    public void exercise(Object bean) {
        this.exercise(bean, FilterSet.excluding(new String[0]));
    }

    public void exercise(Object bean, FilterSet filterSet) {
        ArrayList<Method> gettersDone = new ArrayList<Method>();
        ArrayList<TestException> problems = new ArrayList<TestException>();
        Map<String, Method> methods = PojoTester.getMethodsAsMap(bean);
        for (Map.Entry<String, Method> e : methods.entrySet()) {
            String methodName = e.getKey();
            if (!methodName.startsWith("set") || e.getValue().getParameterTypes().length != 1) continue;
            char first = methodName.charAt(3);
            String remainder = methodName.substring(4);
            String property = Character.toLowerCase(first) + remainder;
            if (!filterSet.shouldInclude(property)) continue;
            try {
                this.testOne(bean, methods, property, gettersDone);
            }
            catch (TestException te) {
                problems.add(te);
            }
        }
        PojoTester.handleExceptions(problems);
    }

    private static void handleExceptions(List<TestException> problems) {
        if (!problems.isEmpty()) {
            Throwable lastCause = null;
            StringBuilder b = new StringBuilder();
            String newline = "";
            for (TestException te : problems) {
                b.append(newline).append(te.getMessage());
                newline = "\n";
                if (te.getCause() == null) continue;
                lastCause = te.getCause();
            }
            throw new AssertionFailedError(b.toString(), lastCause);
        }
    }

    private static Map<String, Method> getMethodsAsMap(Object bean) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method m : bean.getClass().getMethods()) {
            methodMap.put(m.getName(), m);
        }
        return methodMap;
    }

    private void testOne(Object bean, Map<String, Method> methods, String property, List<Method> earlierGetters) throws TestException {
        String setterName = this.getAccessor("set", property);
        for (Method setterMethod : methods.values()) {
            Class<?>[] parameterTypes = setterMethod.getParameterTypes();
            if (!setterMethod.getName().equals(setterName) || parameterTypes.length != 1) continue;
            this.exercise(bean, property, methods, setterMethod, parameterTypes[0], earlierGetters);
            return;
        }
        throw new TestException(String.format("No matching setter found for %s.", property));
    }

    private void exercise(Object bean, String property, Map<String, Method> methods, Method setterMethod, Class<?> parameterType, List<Method> earlierGetters) throws AssertionFailedError, TestException {
        String getterName;
        String setterName = setterMethod.getName();
        DatumFactoryImpl<Object> factory = this.dataByType.get(parameterType);
        if (factory == null) {
            if (Enum.class.isAssignableFrom(parameterType)) {
                final Object[] testData = parameterType.getEnumConstants();
                factory = new DatumFactoryImpl<Object>(Object.class, new Object[0]){
                    private int index;
                    {
                        super(type, data);
                        this.index = testData.length - 1;
                    }

                    @Override
                    public Object getNext() {
                        this.index = (this.index + 1) % testData.length;
                        return testData[this.index];
                    }
                };
                this.dataByType.put(parameterType, factory);
            } else {
                throw new TestException(String.format("No test data is available for %s( %s ).", setterName, parameterType.getName()));
            }
        }
        PojoTester.checkMethodVisibility(property, setterName, setterMethod);
        if (parameterType == Boolean.TYPE) {
            getterName = this.getAccessor("is", property);
            if (property.startsWith("Is") && !methods.containsKey(getterName)) {
                getterName = this.getAccessor("is", property.substring(2));
            }
        } else {
            getterName = this.getAccessor("get", property);
        }
        try {
            Method getterMethod = bean.getClass().getMethod(getterName, new Class[0]);
            if (getterMethod.getReturnType().equals(Void.TYPE)) {
                throw new TestException(String.format("%s(...) is void return.", getterName));
            }
            PojoTester.checkMethodVisibility(property, getterName, getterMethod);
            ArrayList earlierGetterOriginalValues = _Lists.newArrayList();
            for (Method earlierGetter : earlierGetters) {
                Object earlierValue = earlierGetter.invoke(bean, new Object[0]);
                earlierGetterOriginalValues.add(earlierValue);
            }
            for (int i = 0; i < 3; ++i) {
                Object value = factory.getNext();
                PojoTester.invokeSetterAndGetter(bean, property, setterMethod, getterMethod, value);
                int j = 0;
                for (Method earlierGetter : earlierGetters) {
                    Object earlierGetterOriginalValue;
                    Object earlierGetterCurrentValue = earlierGetter.invoke(bean, new Object[0]);
                    if (Objects.equals(earlierGetterOriginalValue = earlierGetterOriginalValues.get(j++), earlierGetterCurrentValue)) continue;
                    throw new TestException(String.format("%s interferes with %s", setterName, earlierGetter.getName()));
                }
            }
            earlierGetters.add(getterMethod);
        }
        catch (Exception e) {
            TestException error = new TestException(String.format("%s: %s", property, e.getMessage()));
            error.initCause(e);
            throw error;
        }
    }

    private static void checkMethodVisibility(String property, String accessorName, Method method) throws AssertionFailedError, TestException {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new TestException(String.format("Test failed for %s because %s is not publicly visible.", property, accessorName));
        }
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            throw new TestException(String.format("Test failed for %s because %s is declared in a class that is not publicly visible.", property, accessorName));
        }
    }

    private static void invokeSetterAndGetter(Object bean, String property, Method setterMethod, Method getterMethod, Object t) throws IllegalAccessException, InvocationTargetException, AssertionFailedError, TestException {
        setterMethod.invoke(bean, t);
        Object r = getterMethod.invoke(bean, new Object[0]);
        if (!t.getClass().equals(r.getClass())) {
            throw new TestException("Test failed for " + property + " because types do not match.");
        }
        if (!t.equals(r)) {
            throw new TestException(String.format("Test failed for %s using %s", property, t));
        }
        if (t instanceof Iterable) {
            Iterator it = ((Iterable)t).iterator();
            Iterator ir = ((Iterable)r).iterator();
            while (it.hasNext() && ir.hasNext()) {
                Object ri;
                Object ti = it.next();
                if (ti.equals(ri = ir.next())) continue;
                throw new TestException(String.format("Test failed for %s with iterator item %s", property, ti));
            }
            if (it.hasNext() || ir.hasNext()) {
                throw new TestException(String.format("Test failed for %s because iteration lengths differ.", property));
            }
        }
    }

    private String getAccessor(String prefix, String property) {
        if (property.length() == 1) {
            return prefix + Character.toUpperCase(property.charAt(0));
        }
        return prefix + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    public static interface DatumFactory<T> {
        public Class<T> getType();

        public T getNext();
    }

    static class DatumFactoryImpl<T>
    implements DatumFactory<T> {
        private final Class<T> type;
        private T[] dataArray;
        private List<T> dataList;
        private int index;

        DatumFactoryImpl() {
            this((Class<T>)null, Collections.emptyList());
        }

        @SafeVarargs
        DatumFactoryImpl(Class<T> type, T ... data) {
            this.type = type;
            this.dataArray = data;
            this.index = data.length - 1;
        }

        DatumFactoryImpl(Class<T> type, List<T> data) {
            this.type = type;
            this.dataList = data;
            this.index = this.dataList.size();
        }

        @Override
        public T getNext() {
            this.index = (this.index + 1) % this.dataArray.length;
            return this.dataList != null ? this.dataList.get(0) : this.dataArray[this.index];
        }

        @Override
        @Generated
        public Class<T> getType() {
            return this.type;
        }
    }

    public static class FilterSet
    extends HashSet<String> {
        private static final long serialVersionUID = 1L;
        private boolean include = false;

        private FilterSet(String ... string) {
            super.addAll(Arrays.asList(string));
        }

        private boolean shouldInclude(String x) {
            if (this.include) {
                return this.isEmpty() || this.contains(x);
            }
            return !this.contains(x);
        }

        public static FilterSet includingOnly(String ... property) {
            FilterSet filterSet = new FilterSet(property);
            filterSet.include = true;
            return filterSet;
        }

        public static FilterSet excluding(String ... property) {
            return new FilterSet(property);
        }
    }

    public static final class TestException
    extends Exception {
        private static final long serialVersionUID = 7870820619976334343L;

        public TestException(String message) {
            super(message);
        }

        public TestException(String message, Throwable t) {
            super(message, t);
        }
    }
}

