/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.soap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.testing.unittestsupport.applib.soap.SoapEndpointSpec;
import org.apache.causeway.testing.unittestsupport.applib.soap.SoapPublishedEndpoints;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SoapEndpointPublishingRule
implements BeforeAllCallback {
    private List<SoapEndpointSpec> soapEndpointSpecs;

    public SoapEndpointPublishingRule(Class<?> endpointClass, String endpointAddress) {
        this.soapEndpointSpecs = Collections.singletonList(new SoapEndpointSpec(endpointClass, endpointAddress));
    }

    public SoapEndpointPublishingRule(Class<?> ... endpointClasses) {
        this.soapEndpointSpecs = _NullSafe.stream((Object[])endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new));
    }

    public SoapEndpointPublishingRule(List<Class<?>> endpointClasses) {
        this.soapEndpointSpecs = _NullSafe.stream(endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new));
    }

    public SoapEndpointPublishingRule(SoapEndpointSpec ... soapEndpointSpecs) {
        this.soapEndpointSpecs = _NullSafe.stream((Object[])soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new));
    }

    public SoapEndpointPublishingRule(Iterable<SoapEndpointSpec> soapEndpointSpecs) {
        this.soapEndpointSpecs = _NullSafe.stream(soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new));
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        SoapPublishedEndpoints.instance().publishIfRequired((Iterable<SoapEndpointSpec>)this.soapEndpointSpecs);
    }

    public String getEndpointAddress(Class<?> endpointClass) {
        return SoapPublishedEndpoints.instance().getEndpointAddress(endpointClass);
    }

    public <T> T getEndpointImplementor(Class<T> endpointClass) {
        return SoapPublishedEndpoints.instance().getEndpointImplementor(endpointClass);
    }
}

