/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.applib.services.menu.model;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuVisitor;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuAction;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuDropdown;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuSpacer;
import org.jspecify.annotations.Nullable;

public record NavbarSection(DomainServiceLayout.MenuBar menuBarSelect, Can<MenuDropdown> topLevelEntries) implements Serializable
{
    public String cssClass() {
        return this.menuBarSelect.name().toLowerCase(Locale.ENGLISH);
    }

    public void visitMenuItems(@Nullable MenuVisitor menuVisitor) {
        if (menuVisitor == null) {
            return;
        }
        this.topLevelEntries.forEach(topLevel -> {
            menuVisitor.onTopLevel((MenuDropdown)topLevel);
            topLevel.subEntries().forEach(subEntry -> {
                Optional<MenuAction> asAction = subEntry.asAction();
                asAction.ifPresentOrElse(menuVisitor::onMenuAction, () -> {
                    Optional<MenuSpacer> asSpacer = subEntry.asSpacer();
                    asSpacer.ifPresent(spacer -> {
                        if (spacer.isEmpty()) {
                            menuVisitor.onSectionSpacer();
                        } else {
                            menuVisitor.onSectionLabel(spacer.label());
                        }
                    });
                });
            });
        });
    }
}

