/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.scalar;

import java.util.Optional;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.UiModel;

public interface UiScalar
extends UiModel,
HasMetaModelContext {
    public ObjectFeature getMetaModel();

    public ManagedObject getOwner();

    public String getIdentifier();

    public String getCssClass();

    public boolean whetherHidden();

    public Optional<InteractionVeto> disabledReason();

    default public String getFriendlyName() {
        return this.getMetaModel().getFriendlyName(this::getOwner);
    }

    default public boolean isSingular() {
        return this.getMetaModel().getFeatureType() == FeatureType.ACTION_PARAMETER_SINGULAR || this.getMetaModel().getFeatureType() == FeatureType.PROPERTY;
    }

    default public boolean isPlural() {
        return this.getMetaModel().getFeatureType() == FeatureType.ACTION_PARAMETER_PLURAL || this.getMetaModel().getFeatureType() == FeatureType.COLLECTION;
    }

    default public boolean isProperty() {
        return this.getMetaModel().getFeatureType().isProperty();
    }

    default public boolean isParameter() {
        return this.getMetaModel().getFeatureType().isActionParameter();
    }

    default public Optional<String> getDescribedAs() {
        return this.getMetaModel().getDescription(this::getOwner);
    }

    default public String getFileAccept() {
        return Facets.fileAccept((ObjectFeature)this.getMetaModel()).orElse(null);
    }

    public int getAutoCompleteMinLength();

    default public boolean isRequired() {
        return !this.getMetaModel().isOptional();
    }

    default public ObjectSpecification getElementType() {
        return this.getMetaModel().getElementType();
    }

    public ManagedObject getDefault();

    public boolean hasChoices();

    public boolean hasAutoComplete();

    default public boolean hasObjectAutoComplete() {
        return Facets.autoCompleteIsPresent((ObjectSpecification)this.getElementType());
    }

    public Can<ManagedObject> getChoices();

    public Can<ManagedObject> getAutoComplete(String var1);

    default public ChoiceProviderSort getChoiceProviderSort() {
        return ChoiceProviderSort.valueOf(this);
    }

    public static enum ChoiceProviderSort {
        NO_CHOICES,
        CHOICES,
        AUTO_COMPLETE,
        OBJECT_AUTO_COMPLETE;


        public static ChoiceProviderSort valueOf(UiScalar scalarModel) {
            if (scalarModel.hasChoices()) {
                return CHOICES;
            }
            if (scalarModel.hasAutoComplete()) {
                return AUTO_COMPLETE;
            }
            if (scalarModel.hasObjectAutoComplete()) {
                return OBJECT_AUTO_COMPLETE;
            }
            return NO_CHOICES;
        }

        public boolean isNoChoices() {
            return this == NO_CHOICES;
        }

        public boolean isChoicesAny() {
            return !this.isNoChoices();
        }
    }
}

