/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.action;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.decorators.DisablingDecorator;

public interface HasManagedAction {
    public ManagedAction getManagedAction();

    public ObjectAction getAction();

    default public ManagedObject getActionOwner() {
        return this.getManagedAction().getOwner();
    }

    default public String getFriendlyName() {
        return this.getManagedAction().getFriendlyName();
    }

    default public Optional<String> getDescription() {
        return this.getManagedAction().getDescription();
    }

    default public boolean hasParameters() {
        return this.getAction().getParameterCount() > 0;
    }

    default public boolean isBookmarkable() {
        ObjectAction action = this.getAction();
        return action.getSemantics().isSafeInNature() && Facets.bookmarkPolicyOrElseNotSpecified((FacetHolder)action).isRoot();
    }

    default public Identifier getFeatureIdentifier() {
        return this.getAction().getFeatureIdentifier();
    }

    default public Optional<FontAwesomeLayers> lookupFontAwesomeLayers(boolean forceAlignmentOnIconAbsence) {
        ManagedAction managedAction = this.getManagedAction();
        return ObjectAction.Util.cssClassFaFactoryFor((ObjectAction)managedAction.getAction(), (ManagedObject)managedAction.getOwner()).map(cssClassFaFactory -> forceAlignmentOnIconAbsence ? cssClassFaFactory.getLayers().emptyToBlank() : cssClassFaFactory.getLayers());
    }

    default public Optional<String> getAdditionalCssClass() {
        return Facets.cssClass((FacetHolder)this.getAction(), (ManagedObject)this.getActionOwner());
    }

    default public ActionLayout.Position getPosition() {
        return ObjectAction.Util.actionLayoutPositionOf((ObjectAction)this.getAction());
    }

    public static <T extends HasManagedAction> Predicate<T> isPositionedAt(ActionLayout.Position position) {
        return a -> a.getPosition() == position;
    }

    default public boolean isPositionedInsideFieldSet() {
        return HasManagedAction.isPositionedAt(ActionLayout.Position.BELOW).or(HasManagedAction.isPositionedAt(ActionLayout.Position.RIGHT)).test(this);
    }

    default public Optional<DisablingDecorator.DisablingDecorationModel> getDisableUiModel() {
        return DisablingDecorator.DisablingDecorationModel.of(this.getManagedAction().checkUsability());
    }
}

