/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.action;

import java.util.stream.Stream;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.consent.Veto;
import org.apache.causeway.core.metamodel.interactions.InteractionHead;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteractionHead;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.MmTitleUtils;
import org.apache.causeway.viewer.commons.model.UiModel;
import org.apache.causeway.viewer.commons.model.action.HasActionInteraction;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.commons.model.mixin.HasTitle;

public interface UiActionForm
extends UiModel,
HasTitle,
HasActionInteraction {
    public Stream<? extends UiParameter> streamPendingParamUiModels();

    default public Consent getUsabilityConsent() {
        return this.getAction().isUsable(this.getActionOwner(), InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
    }

    default public Consent getVisibilityConsent() {
        ManagedObject actionOwner = this.getActionOwner();
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)actionOwner)) {
            return Veto.DEFAULT;
        }
        if (this.getActionOwner().getSpecification().isHidden()) {
            return Veto.DEFAULT;
        }
        return this.getAction().isVisible(actionOwner, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
    }

    default public Consent getValidityConsent() {
        Can proposedArguments = (Can)this.streamPendingParamUiModels().map(UiParameter::getValue).collect(Can.toCan());
        _Assert.assertEquals((Object)this.getAction().getParameterCount(), (Object)proposedArguments.size());
        ActionInteractionHead head = this.getAction().interactionHead(this.getActionOwner());
        return this.getAction().isArgumentSetValid((InteractionHead)head, proposedArguments, InteractionInitiatedBy.USER);
    }

    @Override
    default public String getTitle() {
        ManagedObject owner = this.getActionOwner();
        StringBuilder buf = new StringBuilder();
        this.streamPendingParamUiModels().filter(paramModel -> paramModel.getParameterNegotiationModel().getVisibilityConsent(paramModel.getParameterIndex()).isAllowed()).map(UiParameter::getValue).forEach(paramValue -> {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(MmTitleUtils.abbreviatedTitleOf((ManagedObject)paramValue, (int)8, (String)"..."));
        });
        return owner.getTitle() + "." + this.getFriendlyName() + (String)(buf.length() > 0 ? "(" + buf.toString() + ")" : "");
    }
}

