/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.components;

import lombok.Generated;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

public enum UiComponentType {
    ABOUT,
    WELCOME,
    SERVICE_ACTIONS,
    DOMAIN_OBJECT,
    OBJECT_ICON_AND_TITLE,
    OBJECT_ICON_TITLE_AND_COPYLINK,
    OBJECT_SUMMARY,
    PARENTED_COLLECTION,
    VALUE,
    ATTRIBUTE_NAME_AND_VALUE,
    PARAMETERS,
    PROPERTY_EDIT_FORM,
    ACTION_INFO,
    ACTION_PROMPT,
    PROPERTY_EDIT_PROMPT,
    STANDALONE_COLLECTION,
    COLLECTION_CONTENTS,
    COLLECTION_CONTENTS_EXPORT(Optionality.OPTIONAL),
    OBJECT_LINK,
    EMPTY_COLLECTION,
    VOID_RETURN,
    BOOKMARKED_PAGES,
    UNKNOWN,
    HEADER,
    FOOTER;

    private final Optionality optionality;

    private UiComponentType() {
        this.optionality = Optionality.MANDATORY;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return (String)_Strings.asCamelCase.apply((Object)_Strings.lower((String)this.name()));
    }

    @Nullable
    public static UiComponentType lookup(String id) {
        for (UiComponentType uiComponentType : UiComponentType.values()) {
            if (!uiComponentType.getId().equals(id)) continue;
            return uiComponentType;
        }
        return null;
    }

    @Generated
    private UiComponentType(Optionality optionality) {
        this.optionality = optionality;
    }

    @Generated
    public Optionality getOptionality() {
        return this.optionality;
    }
}

