/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.decorators;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.core.config.messages.MessageRegistry;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;

@FunctionalInterface
public interface ConfirmDecorator<T> {
    public void decorate(T var1, ConfirmDecorationModel var2);

    public record ConfirmDecorationModel(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull UiPlacementDirection placement) {
        @Generated
        public ConfirmDecorationModel(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull UiPlacementDirection placement) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (okLabel == null) {
                throw new NullPointerException("okLabel is marked non-null but is null");
            }
            if (cancelLabel == null) {
                throw new NullPointerException("cancelLabel is marked non-null but is null");
            }
            if (placement == null) {
                throw new NullPointerException("placement is marked non-null but is null");
            }
        }

        public static ConfirmDecorationModel areYouSure(UiPlacementDirection placement) {
            TranslationService translationService = MetaModelContext.translationServiceOrFallback();
            TranslationContext context = TranslationContext.forClassName(MessageRegistry.class);
            String areYouSure = translationService.translate(context, "Are you sure?");
            String confirm = translationService.translate(context, "Confirm");
            String cancel = translationService.translate(context, "Cancel");
            Optional<String> message = Optional.empty();
            return new ConfirmDecorationModel(areYouSure, message, confirm, cancel, placement);
        }
    }
}

