/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.prism;

import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public record PrismLanguage(String languageId) {
    public String cssClass() {
        return "language-" + this.languageId;
    }

    public String jsFile() {
        return "prism/components/prism-" + this.languageId + ".min.js";
    }

    public static Optional<PrismLanguage> parseFromCssClass(@Nullable String cssClass) {
        if (!StringUtils.hasLength((String)cssClass)) {
            return Optional.empty();
        }
        int start = cssClass.indexOf("language-");
        if (start == -1) {
            return Optional.empty();
        }
        String languageKey = cssClass.substring(start + 9);
        int w = languageKey.indexOf(" ");
        if (w > -1) {
            languageKey = languageKey.substring(0, w);
        }
        return Optional.of(new PrismLanguage(languageKey));
    }

    @Deprecated
    public static List<PrismLanguage> mostCommon() {
        return List.of("markup", "css", "clike", "java", "javascript", "asciidoc", "javadoclike", "javadoc", "json", "properties", "xml-doc", "yaml").stream().map(PrismLanguage::new).toList();
    }
}

