/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.prism;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.viewer.commons.prism.PrismLanguage;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;

final class PrismUtils {
    private static final _Lazy<Engine> ENGINE;
    private static final _Lazy<Source> PRISM_SOURCE;
    private static final Map<String, Optional<String>> resourceCache;

    public static Optional<String> jsResourceMain() {
        return PrismUtils.lookup("prism/prism.js");
    }

    public static Optional<String> jsResource(PrismLanguage prismLanguage) {
        return PrismUtils.lookup(prismLanguage.jsFile());
    }

    @Deprecated
    static String mostCommonGrammerAsJs() {
        return PrismLanguage.mostCommon().stream().map(PrismUtils::jsResource).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
    }

    static Context createPrismContext() {
        Context context = Context.newBuilder((String[])new String[0]).engine((Engine)ENGINE.get()).build();
        context.eval((Source)PRISM_SOURCE.get());
        return context;
    }

    private static Optional<String> lookup(String jsRef) {
        return resourceCache.computeIfAbsent(jsRef, PrismUtils::read);
    }

    private static Optional<String> read(String jsRef) {
        String resourcePath = "META-INF/resources/webjars/" + jsRef;
        InputStream inputStream = _Context.getDefaultClassLoader().getResourceAsStream(resourcePath);
        return inputStream != null ? Optional.of(new String(inputStream.readAllBytes())) : Optional.empty();
    }

    private static void suppressPolyglotFallbackWarning() {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
    }

    @Generated
    private PrismUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PrismUtils.suppressPolyglotFallbackWarning();
        ENGINE = _Lazy.threadSafe(Engine::create);
        PRISM_SOURCE = _Lazy.threadSafe(() -> Source.create((String)"js", (CharSequence)PrismUtils.jsResourceMain().orElseThrow()));
        resourceCache = new ConcurrentHashMap<String, Optional<String>>();
    }
}

