/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.prism;

import java.util.ArrayList;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.causeway.viewer.commons.prism.PrismLanguage;
import org.apache.causeway.viewer.commons.prism.PrismNodeHighlighter;
import org.apache.causeway.viewer.commons.prism.PrismUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Context;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public record PrismHighlighter() implements UnaryOperator<String>
{
    @Generated
    private static final Logger log = LogManager.getLogger(PrismHighlighter.class);

    @Override
    public String apply(String htmlContent) {
        Document doc = Jsoup.parseBodyFragment((String)htmlContent);
        ArrayList<NodeReplacement> replacements = new ArrayList<NodeReplacement>();
        doc.traverse((node, depth) -> {
            if (node instanceof Element) {
                Element element = (Element)node;
                if ("code".equals(node.nodeName())) {
                    PrismLanguage prismLanguage = PrismLanguage.parseFromCssClass(node.attr("class")).orElse(null);
                    if (prismLanguage == null) {
                        return;
                    }
                    String grammarJs = PrismUtils.jsResource(prismLanguage).orElse(null);
                    if (grammarJs == null) {
                        log.warn("grammarJs not found for {}", (Object)prismLanguage);
                        return;
                    }
                    Element newNode = new PrismNodeHighlighter(prismLanguage, () -> {
                        Context context = PrismUtils.createPrismContext();
                        context.eval("js", (CharSequence)grammarJs);
                        return context;
                    }).apply(element);
                    node.parent().attr("class", "highlight language-%s".formatted(prismLanguage.languageId()));
                    replacements.add(new NodeReplacement(element, newNode));
                }
            }
        });
        replacements.forEach(NodeReplacement::apply);
        return doc.body().html();
    }

    private record NodeReplacement(Element oldNode, Element newNode) {
        void apply() {
            this.oldNode.replaceWith((Node)this.newNode);
        }
    }
}

