/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.prism;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.causeway.viewer.commons.prism.PrismLanguage;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

record PrismNodeHighlighter(PrismLanguage prismLanguage, Supplier<Context> contextSupplier) implements UnaryOperator<Element>
{
    @Override
    public Element apply(Element codeNode) {
        try (Context context = this.contextSupplier.get();){
            Value prism = context.getBindings("js").getMember("Prism");
            Value highlight = prism.getMember("highlight");
            Value language = prism.getMember("languages").getMember(this.prismLanguage.languageId());
            StringBuilder html = new StringBuilder();
            codeNode.traverse((node, depth) -> {
                if (depth != 1) {
                    return;
                }
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    String highlightedCode = highlight.execute(new Object[]{textNode.getWholeText(), language, this.prismLanguage.languageId()}).asString();
                    html.append(highlightedCode);
                } else {
                    html.append(node.outerHtml());
                }
            });
            String code = "<code class=\"language-%s\" data-lang=\"%s\">%s</code>".formatted(this.prismLanguage.languageId(), this.prismLanguage.languageId(), html.toString());
            Document doc = Jsoup.parseBodyFragment((String)code);
            Element element = doc.body().child(0);
            return element;
        }
    }
}

