/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.prism;

import java.util.List;
import java.util.Optional;
import lombok.Generated;

public enum PrismTheme {
    DEFAULT("", false),
    COY("-coy", true),
    DARK("-dark", false),
    FUNKY("-funky", false),
    OKAIDIA("-okaidia", false),
    SOLARIZEDLIGHT("-solarizedlight", false),
    TOMORROW("-tomorrow", false),
    TWILIGHT("-twilight", false);

    final String themeSuffix;
    final boolean override;

    public String cssPrimaryFile() {
        return "prism/themes/prism" + this.themeSuffix + ".min.css";
    }

    public Optional<String> cssOverrideFile() {
        return this.override ? Optional.of("prismoverride/prism" + this.themeSuffix + ".css") : Optional.empty();
    }

    public List<String> cssFiles() {
        return this.cssOverrideFile().map(cssOverride -> List.of(this.cssPrimaryFile(), cssOverride)).orElseGet(() -> List.of(this.cssPrimaryFile()));
    }

    @Generated
    private PrismTheme(String themeSuffix, boolean override) {
        this.themeSuffix = themeSuffix;
        this.override = override;
    }
}

