/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain;

import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;

public final class TypeNames {
    public static String objectTypeFieldNameFor(ObjectSpecification objectSpecification) {
        return TypeNames.sanitized(objectSpecification.getLogicalTypeName());
    }

    public static String objectTypeNameFor(ObjectSpecification objectSpecification, SchemaType schemaType) {
        return schemaType.name().toLowerCase() + "__" + TypeNames.sanitized(objectSpecification.getLogicalTypeName());
    }

    public static String metaTypeNameFor(ObjectSpecification objectSpecification, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(objectSpecification, schemaType) + "__gqlv_meta";
    }

    public static String inputTypeNameFor(ObjectSpecification objectSpecification, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(objectSpecification, schemaType) + "__gqlv_input";
    }

    public static String enumTypeNameFor(ObjectSpecification objectSpec, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(objectSpec, schemaType) + "__gqlv_enum";
    }

    public static String actionTypeNameFor(ObjectSpecification owningType, ObjectAction oa, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + oa.asciiId() + "__gqlv_action";
    }

    public static String actionInvokeTypeNameFor(ObjectSpecification owningType, ObjectAction oa, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + oa.asciiId() + "__gqlv_action_invoke";
    }

    public static String actionParamsTypeNameFor(ObjectSpecification owningType, ObjectAction oa, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + oa.asciiId() + "__gqlv_action_params";
    }

    public static String actionArgsTypeNameFor(ObjectSpecification owningType, ObjectAction oa, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + oa.asciiId() + "__gqlv_action_args";
    }

    public static String actionParamTypeNameFor(ObjectSpecification owningType, ObjectActionParameter oap, SchemaType schemaType) {
        ObjectAction objectFeature = oap.getAction();
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + objectFeature.asciiId() + "__" + oap.asciiId() + "__gqlv_action_parameter";
    }

    public static String propertyTypeNameFor(ObjectSpecification owningType, OneToOneAssociation otoa, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + otoa.asciiId() + "__gqlv_property";
    }

    public static String propertyLobTypeNameFor(ObjectSpecification owningType, OneToOneAssociation otoa, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + otoa.asciiId() + "__gqlv_property_lob";
    }

    public static String collectionTypeNameFor(ObjectSpecification owningType, OneToManyAssociation otma, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + otma.asciiId() + "__gqlv_collection";
    }

    public static String memberTypeNameFor(ObjectSpecification owningType, ObjectMember objectMember, SchemaType schemaType) {
        return TypeNames.objectTypeNameFor(owningType, schemaType) + "__" + objectMember.asciiId() + "__gqlv_member";
    }

    static String sanitized(String name) {
        String result = name.replace('.', '_').replace("#", "__").replace("()", "");
        result = TypeNames.hyphenedToCamelCase(result);
        return result;
    }

    private static String hyphenedToCamelCase(String string) {
        int hyphenStart = string.indexOf("-");
        return hyphenStart > 0 ? string.substring(0, hyphenStart) + Arrays.stream(string.substring(hyphenStart + 1).split("-")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining()) : string;
    }

    @Generated
    private TypeNames() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

