/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.stream.Collectors;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public class RichPropertyAutoComplete
extends Element {
    private static final String SEARCH_PARAM_NAME = "search";
    private final MemberInteractor<OneToOneAssociation> memberInteractor;

    public RichPropertyAutoComplete(MemberInteractor<OneToOneAssociation> memberInteractor, Context context) {
        super(context);
        this.memberInteractor = memberInteractor;
        OneToOneAssociation otoa = (OneToOneAssociation)memberInteractor.getObjectMember();
        if (otoa.hasAutoComplete()) {
            ObjectSpecification elementType = otoa.getElementType();
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name("autoComplete").type((GraphQLOutputType)GraphQLList.list((GraphQLType)context.typeMapper.outputTypeFor(elementType, SchemaType.RICH)));
            fieldBuilder.argument(GraphQLArgument.newArgument().name(SEARCH_PARAM_NAME).type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)context.typeMapper.outputTypeFor(String.class)))).build();
            this.setField(fieldBuilder.build());
        } else {
            this.setField(null);
        }
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojo.getClass());
        if (objectSpecification == null) {
            return null;
        }
        OneToOneAssociation association = (OneToOneAssociation)this.memberInteractor.getObjectMember();
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo);
        String searchArg = (String)dataFetchingEnvironment.getArgument(SEARCH_PARAM_NAME);
        Can autoCompleteManagedObjects = association.getAutoComplete(managedObject, searchArg, InteractionInitiatedBy.USER);
        return autoCompleteManagedObjects.stream().map(ManagedObject::getPojo).collect(Collectors.toList());
    }
}

