/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Parent;

public abstract class Element {
    protected final Context context;
    protected final CausewayConfiguration.Viewer.Graphql graphqlConfiguration;
    private GraphQLFieldDefinition field;

    protected Element(Context context) {
        this.context = context;
        this.graphqlConfiguration = this.context.causewayConfiguration.getViewer().getGraphql();
    }

    protected final GraphQLFieldDefinition setField(GraphQLFieldDefinition field) {
        this.field = field;
        return field;
    }

    public final void addDataFetcher(Parent parent) {
        if (this.getField() != null) {
            this.context.codeRegistryBuilder.dataFetcher(parent.coordinatesFor(this.getField()), this::fetchData);
        }
        this.addDataFetchersForChildren();
    }

    public final void addDataFetcher(Parent parent, String fieldName) {
        this.context.codeRegistryBuilder.dataFetcher(parent.coordinatesFor(fieldName), this::fetchData);
        this.addDataFetchersForChildren();
    }

    protected void addDataFetchersForChildren() {
    }

    protected abstract Object fetchData(DataFetchingEnvironment var1);

    public GraphQLFieldDefinition getField() {
        return this.field;
    }
}

