/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common.query;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.Parent;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainObject;

public abstract class CommonTopLevelQueryAbstract
extends ElementCustom
implements Parent {
    private final SchemaStrategy schemaStrategy;
    private final List<Element> domainServices = new ArrayList<Element>();
    private final List<ElementCustom> domainObjects = new ArrayList<ElementCustom>();

    public CommonTopLevelQueryAbstract(SchemaStrategy schemaStrategy, Context context) {
        super(schemaStrategy.getSchemaType().name() + "Schema", context);
        this.schemaStrategy = schemaStrategy;
        context.objectSpecifications().forEach(objectSpec -> {
            switch (objectSpec.getBeanSort()) {
                case ABSTRACT: 
                case VIEW_MODEL: 
                case ENTITY: {
                    CommonDomainObject gqlvDomainObject = schemaStrategy.domainObjectFor((ObjectSpecification)objectSpec, context);
                    this.addChildField(gqlvDomainObject.newField());
                    this.domainObjects.add(gqlvDomainObject);
                }
            }
        });
        context.objectSpecifications().forEach(objectSpec -> {
            switch (objectSpec.getBeanSort()) {
                case MANAGED_BEAN_CONTRIBUTING: {
                    context.serviceRegistry.lookupBeanById(objectSpec.getLogicalTypeName()).ifPresent(servicePojo -> this.domainServices.add(this.addChildFieldFor(schemaStrategy.domainServiceFor((ObjectSpecification)objectSpec, servicePojo, context))));
                }
            }
        });
    }

    public static List<ObjectSpecification> superclassesOf(ObjectSpecification objectSpecification) {
        ArrayList<ObjectSpecification> superclasses = new ArrayList<ObjectSpecification>();
        for (ObjectSpecification superclass = objectSpecification.superclass(); superclass != null && superclass.getCorrespondingClass() != Object.class; superclass = superclass.superclass()) {
            superclasses.add(0, superclass);
        }
        return superclasses;
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment environment) {
        return environment;
    }

    @Override
    public void addDataFetchers() {
        this.addDataFetchersForChildren();
    }

    @Override
    protected void addDataFetchersForChildren() {
        this.domainServices.forEach(domainService -> domainService.addDataFetcher(this));
        this.domainObjects.forEach(domainObject -> domainObject.addDataFetcher(this));
    }

    public SchemaStrategy getSchemaStrategy() {
        return this.schemaStrategy;
    }
}

