/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.mutation;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import java.util.Map;
import java.util.Optional;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.query.ObjectFeatureUtils;
import org.apache.causeway.viewer.graphql.model.exceptions.DisabledException;
import org.apache.causeway.viewer.graphql.model.exceptions.HiddenException;
import org.apache.causeway.viewer.graphql.model.exceptions.InvalidException;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;

public class RichMutationForProperty
extends Element {
    private static final SchemaType SCHEMA_TYPE = SchemaType.RICH;
    private final ObjectSpecification objectSpec;
    private final OneToOneAssociation oneToOneAssociation;
    private String argumentName;

    public RichMutationForProperty(ObjectSpecification objectSpec, OneToOneAssociation oneToOneAssociation, Context context) {
        super(context);
        this.objectSpec = objectSpec;
        this.oneToOneAssociation = oneToOneAssociation;
        this.argumentName = context.causewayConfiguration.getViewer().getGraphql().getMutation().getTargetArgName();
        GraphQLOutputType type = context.typeMapper.outputTypeFor(objectSpec, SchemaType.RICH);
        if (type != null) {
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(RichMutationForProperty.fieldName(objectSpec, oneToOneAssociation)).type(type);
            this.addGqlArguments(fieldBuilder);
            this.setField(fieldBuilder.build());
        } else {
            this.setField(null);
        }
    }

    private static String fieldName(ObjectSpecification objectSpecification, OneToOneAssociation otoa) {
        return TypeNames.objectTypeFieldNameFor(objectSpecification) + "__" + otoa.asciiId();
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Optional<Object> result;
        Object target = dataFetchingEnvironment.getArgument(this.argumentName);
        Environment.For environment = new Environment.For(dataFetchingEnvironment);
        Map argumentValue1 = (Map)target;
        String idValue = (String)argumentValue1.get("id");
        if (idValue != null) {
            Optional bookmarkIfAny;
            ObjectSpecification objectSpecArg = (ObjectSpecification)argumentValue1.get("logicalTypeName");
            if (objectSpecArg != null) {
                bookmarkIfAny = Optional.of(Bookmark.forLogicalTypeNameAndIdentifier((String)objectSpecArg.getLogicalTypeName(), (String)idValue));
            } else {
                Class paramClass = this.objectSpec.getCorrespondingClass();
                bookmarkIfAny = this.context.bookmarkService.bookmarkFor(paramClass, idValue);
            }
            result = bookmarkIfAny.map(arg_0 -> ((BookmarkService)this.context.bookmarkService).lookup(arg_0)).filter(Optional::isPresent).map(Optional::get);
        } else {
            String refValue = (String)argumentValue1.get("ref");
            if (refValue != null) {
                String key = ObjectFeatureUtils.keyFor(refValue);
                BookmarkedPojo value = (BookmarkedPojo)environment.getGraphQlContext().get((Object)key);
                result = Optional.of(value).map(BookmarkedPojo::getTargetPojo);
            } else {
                throw new IllegalArgumentException("Either 'id' or 'ref' must be specified for a DomainObject input type");
            }
        }
        Object sourcePojo = result.orElseThrow();
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)this.objectSpec, (Object)sourcePojo);
        Map arguments = dataFetchingEnvironment.getArguments();
        Object argumentValue = arguments.get(this.oneToOneAssociation.asciiId());
        ManagedObject argumentManagedObject = ManagedObject.adaptProperty((OneToOneAssociation)this.oneToOneAssociation, argumentValue);
        Consent visibleConsent = this.oneToOneAssociation.isVisible(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibleConsent.isVetoed()) {
            throw new HiddenException(this.oneToOneAssociation.getFeatureIdentifier());
        }
        Consent usableConsent = this.oneToOneAssociation.isUsable(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usableConsent.isVetoed()) {
            throw new DisabledException(this.oneToOneAssociation.getFeatureIdentifier());
        }
        Consent validityConsent = this.oneToOneAssociation.isAssociationValid(managedObject, argumentManagedObject, InteractionInitiatedBy.USER);
        if (validityConsent.isVetoed()) {
            throw new InvalidException(validityConsent);
        }
        this.oneToOneAssociation.set(managedObject, argumentManagedObject, InteractionInitiatedBy.USER);
        return managedObject;
    }

    private void addGqlArguments(GraphQLFieldDefinition.Builder fieldBuilder) {
        String targetArgName = this.context.causewayConfiguration.getViewer().getGraphql().getMutation().getTargetArgName();
        fieldBuilder.argument(GraphQLArgument.newArgument().name(targetArgName).type(this.context.typeMapper.inputTypeFor(this.objectSpec, SchemaType.RICH)).build());
        fieldBuilder.argument(GraphQLArgument.newArgument().name(this.oneToOneAssociation.asciiId()).type(this.context.typeMapper.inputTypeFor((OneToOneFeature)this.oneToOneAssociation, TypeMapper.InputContext.INVOKE, SchemaType.RICH)).build());
    }
}

