/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ActionInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionInvokeArgs;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionInvokeResult;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionInvokeTarget;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RichActionInvoke
extends ElementCustom {
    private static final Logger log = LogManager.getLogger(RichActionInvoke.class);
    private final RichActionInvokeTarget target;
    private final RichActionInvokeArgs args;
    private final RichActionInvokeResult result;

    public RichActionInvoke(ActionInteractor actionInteractor, Context context) {
        super(TypeNames.actionInvokeTypeNameFor(actionInteractor.getObjectSpecification(), (ObjectAction)actionInteractor.getObjectMember(), actionInteractor.getSchemaType()), context);
        if (this.isBuilt()) {
            this.target = null;
            this.args = null;
            this.result = null;
            return;
        }
        this.target = new RichActionInvokeTarget(actionInteractor, context);
        this.addChildFieldFor(this.target);
        this.args = new RichActionInvokeArgs(actionInteractor, context);
        this.addChildFieldFor(this.args);
        this.result = new RichActionInvokeResult(actionInteractor, context);
        this.addChildFieldFor(this.result);
        GraphQLObjectType gqlObjectType = this.buildObjectType();
        ObjectAction objectAction = (ObjectAction)actionInteractor.getObjectMember();
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(RichActionInvoke.fieldNameForSemanticsOf(objectAction)).type((GraphQLOutputType)gqlObjectType);
        actionInteractor.addGqlArguments(objectAction, fieldBuilder, TypeMapper.InputContext.INVOKE, objectAction.getParameterCount());
        this.setField(fieldBuilder.build());
    }

    private static String fieldNameForSemanticsOf(ObjectAction objectAction) {
        switch (objectAction.getSemantics()) {
            case SAFE_AND_REQUEST_CACHEABLE: 
            case SAFE: {
                return "invoke";
            }
            case IDEMPOTENT: 
            case IDEMPOTENT_ARE_YOU_SURE: {
                return "invokeIdempotent";
            }
        }
        return "invokeNonIdempotent";
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        dataFetchingEnvironment.getGraphQlContext().put((Object)"arguments", (Object)dataFetchingEnvironment.getArguments());
        return BookmarkedPojo.sourceFrom(dataFetchingEnvironment, this.context);
    }

    @Override
    protected void addDataFetchersForChildren() {
        this.target.addDataFetcher(this);
        this.args.addDataFetcher(this);
        this.result.addDataFetcher(this);
    }
}

