/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetBlobBytes;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetBlobMimeType;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetBlobName;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public class RichPropertyGetBlob
extends ElementCustom {
    final MemberInteractor<OneToOneAssociation> memberInteractor;
    final RichPropertyGetBlobBytes blobName;
    final RichPropertyGetBlobMimeType blobMimeType;
    final RichPropertyGetBlobName blobBytes;
    private final CausewayConfiguration.Viewer.Graphql graphqlConfiguration;

    public RichPropertyGetBlob(MemberInteractor<OneToOneAssociation> memberInteractor, Context context) {
        super(TypeNames.propertyLobTypeNameFor(memberInteractor.getObjectSpecification(), (OneToOneAssociation)memberInteractor.getObjectMember(), memberInteractor.getSchemaType()), context);
        this.memberInteractor = memberInteractor;
        this.graphqlConfiguration = context.causewayConfiguration.getViewer().getGraphql();
        if (this.isBuilt()) {
            this.blobName = null;
            this.blobMimeType = null;
            this.blobBytes = null;
            return;
        }
        this.blobName = new RichPropertyGetBlobBytes(memberInteractor, context);
        this.addChildFieldFor(this.blobName);
        this.blobMimeType = new RichPropertyGetBlobMimeType(memberInteractor, context);
        this.addChildFieldFor(this.blobMimeType);
        this.blobBytes = this.isResourceNotForbidden() ? new RichPropertyGetBlobName(memberInteractor, context) : null;
        this.addChildFieldFor(this.blobBytes);
        this.setField(GraphQLFieldDefinition.newFieldDefinition().name("get").type((GraphQLOutputType)this.buildObjectType()).build());
    }

    private boolean isResourceNotForbidden() {
        return this.graphqlConfiguration.getResources().getResponseType() != CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN;
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        return BookmarkedPojo.sourceFrom(dataFetchingEnvironment, this.context);
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.blobName == null) {
            return;
        }
        this.blobName.addDataFetcher(this);
        this.blobMimeType.addDataFetcher(this);
        if (this.blobBytes != null) {
            this.blobBytes.addDataFetcher(this);
        }
    }
}

