/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import java.util.Optional;
import java.util.function.Function;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public abstract class RichPropertyGetBlobAbstract
extends Element {
    final MemberInteractor<OneToOneAssociation> memberInteractor;

    public RichPropertyGetBlobAbstract(MemberInteractor<OneToOneAssociation> memberInteractor, Context context, String name) {
        super(context);
        this.memberInteractor = memberInteractor;
        this.setField(GraphQLFieldDefinition.newFieldDefinition().name(name).type((GraphQLOutputType)Scalars.GraphQLString).build());
    }

    protected Object fetchDataFromBlob(DataFetchingEnvironment environment, Function<Blob, ?> mapper) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(environment);
        Class<?> sourcePojoClass = sourcePojo.getClass();
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojoClass);
        if (objectSpecification == null) {
            return null;
        }
        OneToOneAssociation association = (OneToOneAssociation)this.memberInteractor.getObjectMember();
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo);
        ManagedObject resultManagedObject = association.get(managedObject);
        return Optional.ofNullable(resultManagedObject).map(ManagedObject::getPojo).filter(Blob.class::isInstance).map(Blob.class::cast).map(mapper).orElse(null);
    }
}

