/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.simple.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public class SimpleCollection
extends Element {
    final ObjectInteractor objectInteractor;
    private final OneToManyAssociation objectMember;

    public SimpleCollection(ObjectInteractor objectInteractor, OneToManyAssociation otma, Context context) {
        super(context);
        this.objectInteractor = objectInteractor;
        this.objectMember = otma;
        GraphQLList objectType = this.context.typeMapper.listTypeForElementTypeOf(otma, objectInteractor.getSchemaType());
        if (objectType != null) {
            this.setField(GraphQLFieldDefinition.newFieldDefinition().name(this.getId()).description(otma.getCanonicalDescription().orElse(otma.getCanonicalFriendlyName())).type((GraphQLOutputType)objectType).build());
        } else {
            this.setField(null);
        }
    }

    public String getId() {
        return this.objectMember.asciiId();
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment environment) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(environment);
        Class<?> sourcePojoClass = sourcePojo.getClass();
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojoClass);
        if (objectSpecification == null) {
            return null;
        }
        OneToManyAssociation otma = this.objectMember;
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo);
        ManagedObject resultManagedObject = otma.get(managedObject);
        return resultManagedObject != null ? resultManagedObject.getPojo() : null;
    }
}

