/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.types;

import graphql.Scalars;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import lombok.Generated;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.types.ScalarMapper;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

public class TypeMapperDefault
implements TypeMapper {
    private final ScalarMapper scalarMapper;
    private final Provider<Context> contextProvider;

    @Override
    public GraphQLOutputType outputTypeFor(Class<?> clazz) {
        if (clazz.isEnum()) {
            return ((Context)this.contextProvider.get()).graphQLTypeRegistry.addEnumTypeIfNotAlreadyPresent(clazz, SchemaType.RICH);
        }
        return this.scalarMapper.scalarTypeFor(clazz);
    }

    @Override
    public GraphQLInputType inputTypeFor(Class<?> clazz) {
        if (clazz.isEnum()) {
            return ((Context)this.contextProvider.get()).graphQLTypeRegistry.addEnumTypeIfNotAlreadyPresent(clazz, SchemaType.RICH);
        }
        return this.scalarMapper.scalarTypeFor(clazz);
    }

    @Override
    public Object unmarshal(Object gqlValue, ObjectSpecification targetObjectSpec) {
        Class correspondingClass = targetObjectSpec.getCorrespondingClass();
        if (correspondingClass.isEnum()) {
            return gqlValue;
        }
        return this.scalarMapper.unmarshal(gqlValue, correspondingClass);
    }

    @Override
    public GraphQLOutputType outputTypeFor(OneToOneFeature oneToOneFeature, SchemaType schemaType) {
        ObjectSpecification otoaObjectSpec = oneToOneFeature.getElementType();
        switch (otoaObjectSpec.getBeanSort()) {
            case VIEW_MODEL: {
                return TypeMapperDefault.typeRefPossiblyOptional(oneToOneFeature, schemaType, otoaObjectSpec);
            }
            case ENTITY: {
                return TypeMapperDefault.typeRefPossiblyOptional(oneToOneFeature, schemaType, otoaObjectSpec);
            }
            case VALUE: {
                return this.scalarTypePossiblyOptional(oneToOneFeature, otoaObjectSpec);
            }
        }
        return null;
    }

    private static GraphQLOutputType typeRefPossiblyOptional(OneToOneFeature oneToOneFeature, SchemaType schemaType, ObjectSpecification otoaObjectSpec) {
        GraphQLTypeReference fieldTypeRef = GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(otoaObjectSpec, schemaType));
        return oneToOneFeature.isOptional() ? fieldTypeRef : GraphQLNonNull.nonNull((GraphQLType)fieldTypeRef);
    }

    private GraphQLOutputType scalarTypePossiblyOptional(OneToOneFeature oneToOneFeature, ObjectSpecification otoaObjectSpec) {
        GraphQLOutputType scalarType = this.outputTypeFor(otoaObjectSpec.getCorrespondingClass());
        return oneToOneFeature.isOptional() ? scalarType : GraphQLNonNull.nonNull((GraphQLType)scalarType);
    }

    @Override
    @Nullable
    public GraphQLOutputType outputTypeFor(ObjectSpecification objectSpecification, SchemaType schemaType) {
        switch (objectSpecification.getBeanSort()) {
            case VIEW_MODEL: 
            case ABSTRACT: {
                return GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(objectSpecification, schemaType));
            }
            case ENTITY: {
                return GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(objectSpecification, schemaType));
            }
            case VALUE: {
                return this.outputTypeFor(objectSpecification.getCorrespondingClass());
            }
            case COLLECTION: {
                return null;
            }
        }
        return Scalars.GraphQLString;
    }

    @Override
    @Nullable
    public GraphQLList listTypeForElementTypeOf(OneToManyAssociation oneToManyAssociation, SchemaType schemaType) {
        ObjectSpecification elementType = oneToManyAssociation.getElementType();
        return this.listTypeFor(elementType, schemaType);
    }

    @Override
    @Nullable
    public GraphQLList listTypeFor(ObjectSpecification elementType, SchemaType schemaType) {
        switch (elementType.getBeanSort()) {
            case VIEW_MODEL: 
            case ENTITY: {
                return GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(elementType, schemaType)));
            }
            case VALUE: {
                return GraphQLList.list((GraphQLType)this.outputTypeFor(elementType.getCorrespondingClass()));
            }
        }
        return null;
    }

    @Override
    public GraphQLInputType inputTypeFor(OneToOneFeature oneToOneFeature, TypeMapper.InputContext inputContext, SchemaType schemaType) {
        return oneToOneFeature.isOptional() || inputContext.isOptionalAlwaysAllowed() ? this.inputTypeFor_(oneToOneFeature, schemaType) : GraphQLNonNull.nonNull((GraphQLType)this.inputTypeFor_(oneToOneFeature, schemaType));
    }

    private GraphQLInputType inputTypeFor_(OneToOneFeature oneToOneFeature, SchemaType schemaType) {
        ObjectSpecification elementObjectSpec = oneToOneFeature.getElementType();
        switch (elementObjectSpec.getBeanSort()) {
            case VIEW_MODEL: 
            case ABSTRACT: {
                return GraphQLTypeReference.typeRef((String)TypeNames.inputTypeNameFor(elementObjectSpec, schemaType));
            }
            case ENTITY: {
                return GraphQLTypeReference.typeRef((String)TypeNames.inputTypeNameFor(elementObjectSpec, schemaType));
            }
            case VALUE: {
                return this.inputTypeFor(elementObjectSpec.getCorrespondingClass());
            }
            case COLLECTION: {
                throw new IllegalArgumentException(String.format("OneToOneFeature '%s' is not expected to have a beanSort of COLLECTION", oneToOneFeature.getFeatureIdentifier().toString()));
            }
        }
        return Scalars.GraphQLString;
    }

    @Override
    public GraphQLList inputTypeFor(OneToManyActionParameter oneToManyActionParameter, SchemaType schemaType) {
        ObjectSpecification elementObjectSpec = oneToManyActionParameter.getElementType();
        return GraphQLList.list((GraphQLType)this.inputTypeFor(elementObjectSpec, schemaType));
    }

    @Override
    public GraphQLInputType inputTypeFor(ObjectSpecification elementType, SchemaType schemaType) {
        switch (elementType.getBeanSort()) {
            case VIEW_MODEL: 
            case ABSTRACT: {
                return GraphQLTypeReference.typeRef((String)TypeNames.inputTypeNameFor(elementType, schemaType));
            }
            case ENTITY: {
                return GraphQLTypeReference.typeRef((String)TypeNames.inputTypeNameFor(elementType, schemaType));
            }
            case VALUE: {
                return this.inputTypeFor(elementType.getCorrespondingClass());
            }
            case COLLECTION: {
                throw new IllegalArgumentException(String.format("ObjectSpec '%s' is not expected to have a beanSort of COLLECTION", elementType.getFullIdentifier()));
            }
        }
        return Scalars.GraphQLString;
    }

    @Inject
    @Generated
    public TypeMapperDefault(ScalarMapper scalarMapper, Provider<Context> contextProvider) {
        this.scalarMapper = scalarMapper;
        this.contextProvider = contextProvider;
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={TypeMapper.class})
        public TypeMapper defaultTypeMapper(ScalarMapper scalarMapper, Provider<Context> contextProvider) {
            return new TypeMapperDefault(scalarMapper, contextProvider);
        }
    }
}

