/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.stream.Collectors;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.PropertyInteractor;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;

public class RichPropertyChoices
extends Element {
    final PropertyInteractor propertyInteractor;

    public RichPropertyChoices(PropertyInteractor propertyInteractor, Context context) {
        super(context);
        this.propertyInteractor = propertyInteractor;
        OneToOneAssociation otoa = (OneToOneAssociation)propertyInteractor.getObjectMember();
        if (otoa.hasChoices()) {
            ObjectSpecification elementType = otoa.getElementType();
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name("choices").type((GraphQLOutputType)GraphQLList.list((GraphQLType)context.typeMapper.outputTypeFor(elementType, SchemaType.RICH)));
            propertyInteractor.addGqlArgument(otoa, fieldBuilder, TypeMapper.InputContext.CHOICES);
            this.setField(fieldBuilder.build());
        } else {
            this.setField(null);
        }
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojo.getClass());
        if (objectSpecification == null) {
            return null;
        }
        OneToOneAssociation association = (OneToOneAssociation)this.propertyInteractor.getObjectMember();
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo);
        Can choicesManagedObject = association.getChoices(managedObject, InteractionInitiatedBy.USER);
        return choicesManagedObject.stream().map(ManagedObject::getPojo).collect(Collectors.toList());
    }
}

