/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.simple;

import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainObject;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonMeta;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimpleAction;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimpleCollection;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimpleProperty;

public class SchemaStrategySimple
implements SchemaStrategy {
    @Override
    public SchemaType getSchemaType() {
        return SchemaType.SIMPLE;
    }

    @Override
    public String topLevelFieldNameFrom(CausewayConfiguration.Viewer.Graphql graphqlConfiguration) {
        return graphqlConfiguration.getSchema().getSimple().getTopLevelFieldName();
    }

    @Override
    public Element newProperty(ObjectInteractor holder, OneToOneAssociation otoa, Context context) {
        return new SimpleProperty(holder, otoa, context);
    }

    @Override
    public Element newCollection(ObjectInteractor holder, OneToManyAssociation otma, Context context) {
        return new SimpleCollection(holder, otma, context);
    }

    @Override
    public Element newAction(ObjectInteractor holder, ObjectAction objectAction, Context context) {
        return new SimpleAction(holder, objectAction, context);
    }

    @Override
    public ElementCustom newMeta(CommonDomainObject commonDomainObject, Context context) {
        return new CommonMeta(commonDomainObject, context);
    }

    @Override
    public boolean shouldInclude(CausewayConfiguration.Viewer.Graphql.ApiVariant apiVariant, ObjectAction objectAction) {
        switch (apiVariant) {
            case QUERY_ONLY: 
            case QUERY_AND_MUTATIONS: {
                return objectAction.getSemantics().isSafeInNature();
            }
            case QUERY_WITH_MUTATIONS_NON_SPEC_COMPLIANT: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown API variant: " + String.valueOf(apiVariant));
    }
}

