/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.PropertyInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichAssociation;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMemberDisabled;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMemberHidden;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyAutoComplete;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyChoices;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyDatatype;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGet;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetBlob;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetClob;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertySet;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyValidate;
import org.apache.causeway.viewer.graphql.model.mmproviders.ObjectMemberProvider;
import org.apache.causeway.viewer.graphql.model.mmproviders.ObjectSpecificationProvider;
import org.apache.causeway.viewer.graphql.model.mmproviders.SchemaTypeProvider;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;

public class RichProperty
extends RichAssociation<OneToOneAssociation, ObjectInteractor>
implements MemberInteractor<OneToOneAssociation>,
PropertyInteractor,
ObjectSpecificationProvider,
ObjectMemberProvider<OneToOneAssociation>,
SchemaTypeProvider {
    private final RichMemberHidden<OneToOneAssociation> hidden;
    private final RichMemberDisabled<OneToOneAssociation> disabled;
    private final Element get;
    private final RichPropertyChoices choices;
    private final RichPropertyAutoComplete autoComplete;
    private final RichPropertyValidate validate;
    private final RichPropertySet set;
    private final RichPropertyDatatype datatype;

    public RichProperty(ObjectInteractor holder, OneToOneAssociation otoa, Context context) {
        super(holder, otoa, TypeNames.propertyTypeNameFor(holder.getObjectSpecification(), otoa, holder.getSchemaType()), context);
        if (this.isBuilt()) {
            this.hidden = null;
            this.disabled = null;
            this.choices = null;
            this.autoComplete = null;
            this.validate = null;
            this.set = null;
            this.datatype = null;
            this.get = null;
            return;
        }
        this.hidden = new RichMemberHidden<OneToOneAssociation>(this, context);
        this.addChildFieldFor(this.hidden);
        this.disabled = new RichMemberDisabled<OneToOneAssociation>(this, context);
        this.addChildFieldFor(this.disabled);
        this.get = this.isBlob() ? new RichPropertyGetBlob(this, context) : (this.isClob() ? new RichPropertyGetClob(this, context) : new RichPropertyGet(this, context));
        this.addChildFieldFor(this.get);
        this.validate = new RichPropertyValidate(this, context);
        this.addChildFieldFor(this.validate);
        this.choices = new RichPropertyChoices(this, context);
        this.addChildFieldFor(this.choices);
        this.autoComplete = new RichPropertyAutoComplete(this, context);
        this.addChildFieldFor(this.autoComplete);
        this.set = this.isSetterAllowed() ? new RichPropertySet(this, context) : null;
        this.addChildFieldFor(this.set);
        this.datatype = new RichPropertyDatatype(this, context);
        this.addChildFieldFor(this.datatype);
        this.buildObjectTypeAndField(otoa.asciiId(), otoa.getCanonicalDescription().orElse(otoa.getCanonicalFriendlyName()));
    }

    private boolean isSetterAllowed() {
        CausewayConfiguration.Viewer.Graphql.ApiVariant apiVariant = this.context.causewayConfiguration.getViewer().getGraphql().getApiVariant();
        switch (apiVariant) {
            case QUERY_ONLY: 
            case QUERY_AND_MUTATIONS: {
                return false;
            }
            case QUERY_WITH_MUTATIONS_NON_SPEC_COMPLIANT: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown API variant: " + String.valueOf(apiVariant));
    }

    private boolean isBlob() {
        return this.getOneToOneAssociation().getElementType().getCorrespondingClass() == Blob.class;
    }

    private boolean isClob() {
        return this.getOneToOneAssociation().getElementType().getCorrespondingClass() == Clob.class;
    }

    @Override
    public void addGqlArgument(OneToOneAssociation oneToOneAssociation, GraphQLFieldDefinition.Builder builder, TypeMapper.InputContext inputContext) {
        builder.argument(this.gqlArgumentFor(oneToOneAssociation, inputContext));
    }

    private GraphQLArgument gqlArgumentFor(OneToOneAssociation otoa, TypeMapper.InputContext inputContext) {
        return GraphQLArgument.newArgument().name(otoa.asciiId()).type(this.context.typeMapper.inputTypeFor((OneToOneFeature)otoa, inputContext, SchemaType.RICH)).build();
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return ((ObjectInteractor)this.interactor).getObjectSpecification();
    }

    public OneToOneAssociation getOneToOneAssociation() {
        return (OneToOneAssociation)this.getObjectMember();
    }

    @Override
    protected void addDataFetchersForChildren() {
        this.hidden.addDataFetcher(this);
        this.disabled.addDataFetcher(this);
        this.get.addDataFetcher(this);
        if (this.choices != null) {
            this.choices.addDataFetcher(this);
        }
        if (this.autoComplete != null) {
            this.autoComplete.addDataFetcher(this);
        }
        this.validate.addDataFetcher(this);
        if (this.set != null) {
            this.set.addDataFetcher(this);
        }
        this.datatype.addDataFetcher(this);
    }

    @Override
    public SchemaType getSchemaType() {
        return ((ObjectInteractor)this.interactor).getSchemaType();
    }
}

