/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import java.util.Map;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.PropertyInteractor;
import org.apache.causeway.viewer.graphql.model.exceptions.DisabledException;
import org.apache.causeway.viewer.graphql.model.exceptions.HiddenException;
import org.apache.causeway.viewer.graphql.model.exceptions.InvalidException;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;

public class RichPropertySet
extends Element {
    final PropertyInteractor propertyInteractor;

    public RichPropertySet(PropertyInteractor propertyInteractor, Context context) {
        super(context);
        this.propertyInteractor = propertyInteractor;
        GraphQLOutputType graphQLOutputType = this.context.typeMapper.outputTypeFor(propertyInteractor.getObjectSpecification(), SchemaType.RICH);
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name("set").type(graphQLOutputType);
        propertyInteractor.addGqlArgument((OneToOneAssociation)propertyInteractor.getObjectMember(), fieldBuilder, TypeMapper.InputContext.INVOKE);
        this.setField(fieldBuilder.build());
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        Class<?> sourcePojoClass = sourcePojo.getClass();
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojoClass);
        if (objectSpecification == null) {
            return null;
        }
        OneToOneAssociation otoa = (OneToOneAssociation)this.propertyInteractor.getObjectMember();
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo);
        Map arguments = dataFetchingEnvironment.getArguments();
        Object argumentValue = arguments.get(otoa.asciiId());
        ManagedObject argumentManagedObject = ManagedObject.adaptProperty((OneToOneAssociation)otoa, argumentValue);
        Consent visibleConsent = otoa.isVisible(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibleConsent.isVetoed()) {
            throw new HiddenException(otoa.getFeatureIdentifier());
        }
        Consent usableConsent = otoa.isUsable(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usableConsent.isVetoed()) {
            throw new DisabledException(otoa.getFeatureIdentifier());
        }
        Consent validityConsent = otoa.isAssociationValid(managedObject, argumentManagedObject, InteractionInitiatedBy.USER);
        if (validityConsent.isVetoed()) {
            throw new InvalidException(validityConsent);
        }
        otoa.set(managedObject, argumentManagedObject, InteractionInitiatedBy.USER);
        return managedObject;
    }
}

