/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common;

import java.util.List;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainObject;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainService;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonTopLevelQueryAbstract;
import org.apache.causeway.viewer.graphql.model.domain.rich.SchemaStrategyRich;
import org.apache.causeway.viewer.graphql.model.domain.simple.SchemaStrategySimple;

public interface SchemaStrategy {
    public static final SchemaStrategy RICH = new SchemaStrategyRich();
    public static final SchemaStrategy SIMPLE = new SchemaStrategySimple();

    public SchemaType getSchemaType();

    default public CommonDomainObject domainObjectFor(ObjectSpecification objectSpecification, Context context) {
        SchemaStrategy.mapSuperclassesIfNecessary(this, objectSpecification, context);
        String typeNameFor = CommonDomainObject.typeNameFor(this, objectSpecification);
        return context.domainObjectByTypeName.computeIfAbsent(typeNameFor, typeName -> new CommonDomainObject(this, (String)typeName, objectSpecification, context));
    }

    default public CommonDomainService domainServiceFor(ObjectSpecification objectSpecification, Object servicePojo, Context context) {
        String typeNameFor = CommonDomainService.typeNameFor(this, objectSpecification);
        return context.domainServiceByTypeName.computeIfAbsent(typeNameFor, typeName -> new CommonDomainService(this, (String)typeName, objectSpecification, servicePojo, context));
    }

    public String topLevelFieldNameFrom(CausewayConfiguration.Viewer.Graphql var1);

    public Element newProperty(ObjectInteractor var1, OneToOneAssociation var2, Context var3);

    public Element newCollection(ObjectInteractor var1, OneToManyAssociation var2, Context var3);

    public Element newAction(ObjectInteractor var1, ObjectAction var2, Context var3);

    public ElementCustom newMeta(CommonDomainObject var1, Context var2);

    private static void mapSuperclassesIfNecessary(SchemaStrategy schemaStrategy, ObjectSpecification objectSpecification, Context context) {
        String typeName = CommonDomainObject.typeNameFor(schemaStrategy, objectSpecification);
        if (context.domainObjectByTypeName.containsKey(typeName)) {
            return;
        }
        List<ObjectSpecification> superclasses = CommonTopLevelQueryAbstract.superclassesOf(objectSpecification);
        superclasses.forEach(objectSpec -> {
            String typeNameForSuperclass = CommonDomainObject.typeNameFor(schemaStrategy, objectSpecification);
            context.domainObjectByTypeName.computeIfAbsent(typeNameForSuperclass, typeNm -> new CommonDomainObject(schemaStrategy, (String)typeNm, objectSpecification, context));
        });
    }

    public boolean shouldInclude(CausewayConfiguration.Viewer.Graphql.ApiVariant var1, ObjectAction var2);
}

