/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.scenario;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.rich.scenario.ScenarioName;
import org.apache.causeway.viewer.graphql.model.domain.rich.scenario.ScenarioStep;

public class Scenario
extends ElementCustom {
    public static final String KEY_SCENARIO_NAME = String.format("%s#%s", Scenario.class.getName(), "name");
    private final ScenarioName scenarioName;
    private final ScenarioStep scenarioStep;

    public Scenario(SchemaStrategy schemaStrategy, Context context) {
        super("Scenario", context);
        this.scenarioName = new ScenarioName(context);
        this.addChildFieldFor(this.scenarioName);
        this.scenarioStep = new ScenarioStep(schemaStrategy, context);
        this.addChildField(this.scenarioStep.newField("Given", "Given the system under test has this initial state"));
        this.addChildField(this.scenarioStep.newField("When", "When the system is changed in some particular way"));
        this.addChildField(this.scenarioStep.newField("Then", "Then the system has this resultant state"));
        this.buildObjectType();
        this.setField(GraphQLFieldDefinition.newFieldDefinition().name("Scenario").type((GraphQLOutputType)this.getGqlObjectType()).argument(new GraphQLArgument.Builder().name("name").type((GraphQLInputType)Scalars.GraphQLString)).build());
    }

    @Override
    protected void addDataFetchersForChildren() {
        this.scenarioName.addDataFetcher(this);
        this.scenarioStep.addDataFetcher(this, "Given");
        this.scenarioStep.addDataFetcher(this, "When");
        this.scenarioStep.addDataFetcher(this, "Then");
    }

    protected DataFetchingEnvironment fetchData(DataFetchingEnvironment environment) {
        String scenarioName = (String)environment.getArgument("name");
        environment.getGraphQlContext().put((Object)KEY_SCENARIO_NAME, (Object)scenarioName);
        return environment;
    }
}

