/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.marshallers;

import graphql.Scalars;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.graphql.applib.marshallers.ScalarMarshallerAbstract;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class ScalarMarshallerJdk8ZonedDateTime
extends ScalarMarshallerAbstract<ZonedDateTime> {
    private final CausewayConfiguration.Viewer.Graphql.ScalarMarshaller scalarMarshallerConfig;

    @Inject
    public ScalarMarshallerJdk8ZonedDateTime(CausewayConfiguration causewayConfiguration) {
        super(ZonedDateTime.class, Scalars.GraphQLString, causewayConfiguration);
        this.scalarMarshallerConfig = causewayConfiguration.getViewer().getGraphql().getScalarMarshaller();
    }

    public ZonedDateTime unmarshal(Object graphValue, Class<?> targetType) {
        String argumentStr = (String)graphValue;
        return ZonedDateTime.parse(argumentStr, DateTimeFormatter.ofPattern(this.scalarMarshallerConfig.getZonedDateTimeFormat()));
    }
}

