/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.viewer.auth;

import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import jakarta.inject.Inject;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.services.user.RoleMemento;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.graphql.applib.auth.UserMementoProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class UserMementoProviderDefault
implements UserMementoProvider {
    @Inject
    private final CausewayConfiguration causewayConfiguration;

    public UserMemento userMemento(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        String fallbackUsername = this.causewayConfiguration.getViewer().getGraphql().getAuthentication().getFallback().getUsername();
        if (fallbackUsername == null) {
            return null;
        }
        List fallbackRoles = this.causewayConfiguration.getViewer().getGraphql().getAuthentication().getFallback().getRoles();
        Can roles = Can.ofStream(fallbackRoles.stream().map(roleName -> RoleMemento.builder().name(roleName).build()));
        return UserMemento.builder().name(fallbackUsername).roles(roles).build();
    }

    @Inject
    @Generated
    public UserMementoProviderDefault(CausewayConfiguration causewayConfiguration) {
        this.causewayConfiguration = causewayConfiguration;
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={UserMementoProvider.class})
        public UserMementoProvider defaultIdentityProvider(CausewayConfiguration causewayConfiguration) {
            return new UserMementoProviderDefault(causewayConfiguration);
        }
    }
}

