/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.util.PathNode;

public abstract class Parser<T> {
    public T valueOf(List<String> str) {
        if (str == null) {
            return null;
        }
        if (str.size() == 0) {
            return null;
        }
        return this.valueOf(str.get(0));
    }

    public T valueOf(String[] str) {
        if (str == null) {
            return null;
        }
        if (str.length == 0) {
            return null;
        }
        return this.valueOf(str[0]);
    }

    public T valueOf(JsonRepresentation jsonRepresentation) {
        if (jsonRepresentation == null) {
            return null;
        }
        return this.valueOf(jsonRepresentation.asString());
    }

    public JsonRepresentation asJsonRepresentation(T t) {
        return JsonRepresentation.newMap("dummy", this.asString(t)).getRepresentation("dummy", new Object[0]);
    }

    public abstract T valueOf(String var1);

    public abstract String asString(T var1);

    public static final Parser<String> forString() {
        return new Parser<String>(){

            @Override
            public String valueOf(String str) {
                return str;
            }

            @Override
            public String asString(String t) {
                return t;
            }
        };
    }

    public static Parser<Date> forDate() {
        return new Parser<Date>(){
            private final SimpleDateFormat RFC1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z");

            @Override
            public Date valueOf(String str) {
                if (str == null) {
                    return null;
                }
                try {
                    return this.RFC1123_DATE_FORMAT.parse(str);
                }
                catch (ParseException e) {
                    return null;
                }
            }

            @Override
            public String asString(Date t) {
                return this.RFC1123_DATE_FORMAT.format(t);
            }
        };
    }

    public static Parser<CacheControl> forCacheControl() {
        return new Parser<CacheControl>(){

            @Override
            public CacheControl valueOf(String str) {
                if (str == null) {
                    return null;
                }
                CacheControl cacheControl = (CacheControl)RuntimeDelegate.getInstance().createHeaderDelegate(CacheControl.class).fromString(str);
                cacheControl.getCacheExtension();
                cacheControl.getNoCacheFields();
                return cacheControl;
            }

            @Override
            public String asString(CacheControl cacheControl) {
                return RuntimeDelegate.getInstance().createHeaderDelegate(CacheControl.class).toString((Object)cacheControl);
            }
        };
    }

    public static Parser<MediaType> forJaxRsMediaType() {
        return new Parser<MediaType>(){

            @Override
            public MediaType valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return MediaType.valueOf((String)str);
            }

            @Override
            public String asString(MediaType t) {
                return t.toString();
            }
        };
    }

    public static Parser<Boolean> forBoolean() {
        return new Parser<Boolean>(){

            @Override
            public Boolean valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return "yes".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public String asString(Boolean t) {
                return t != false ? "yes" : "no";
            }
        };
    }

    public static Parser<Integer> forInteger() {
        return new Parser<Integer>(){

            @Override
            public Integer valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return Integer.valueOf(str);
            }

            @Override
            public String asString(Integer t) {
                return t.toString();
            }
        };
    }

    public static Parser<List<String>> forListOfStrings() {
        return new Parser<List<String>>(){

            @Override
            public List<String> valueOf(List<String> strings) {
                if (strings == null) {
                    return Collections.emptyList();
                }
                if (strings.size() == 1) {
                    return this.valueOf(strings.get(0));
                }
                return strings;
            }

            @Override
            public List<String> valueOf(String[] strings) {
                if (strings == null) {
                    return Collections.emptyList();
                }
                if (strings.length == 1) {
                    return this.valueOf(strings[0]);
                }
                return Arrays.asList(strings);
            }

            @Override
            public List<String> valueOf(String str) {
                if (str == null) {
                    return Collections.emptyList();
                }
                return _Strings.splitThenStream((String)str, (String)",").collect(Collectors.toList());
            }

            @Override
            public String asString(List<String> strings) {
                return _NullSafe.stream(strings).collect(Collectors.joining(","));
            }
        };
    }

    public static Parser<List<List<String>>> forListOfListOfStrings() {
        return new Parser<List<List<String>>>(){

            @Override
            public List<List<String>> valueOf(List<String> str) {
                if (str == null) {
                    return null;
                }
                if (str.size() == 0) {
                    return null;
                }
                ArrayList listOfLists = _Lists.newArrayList();
                for (String s : str) {
                    listOfLists.add(PathNode.split(s));
                }
                return listOfLists;
            }

            @Override
            public List<List<String>> valueOf(String[] str) {
                if (str == null) {
                    return null;
                }
                if (str.length == 0) {
                    return null;
                }
                return this.valueOf((List)Arrays.asList(str));
            }

            @Override
            public List<List<String>> valueOf(String str) {
                if (str == null || str.isEmpty()) {
                    return Collections.emptyList();
                }
                return _Strings.splitThenStream((String)str, (String)",").map(PathNode::split).collect(Collectors.toList());
            }

            @Override
            public String asString(List<List<String>> listOfLists) {
                return _NullSafe.stream(listOfLists).map(listOfStrings -> _NullSafe.stream((Collection)listOfStrings).collect(Collectors.joining("."))).collect(Collectors.joining(","));
            }
        };
    }

    public static Parser<String[]> forArrayOfStrings() {
        return new Parser<String[]>(){

            @Override
            public String[] valueOf(List<String> strings) {
                if (strings == null) {
                    return _Constants.emptyStringArray;
                }
                if (strings.size() == 1) {
                    return this.valueOf(strings.get(0));
                }
                return strings.toArray(new String[0]);
            }

            @Override
            public String[] valueOf(String[] strings) {
                if (strings == null) {
                    return _Constants.emptyStringArray;
                }
                if (strings.length == 1) {
                    return this.valueOf(strings[0]);
                }
                return strings;
            }

            @Override
            public String[] valueOf(String str) {
                if (str == null) {
                    return _Constants.emptyStringArray;
                }
                return _Strings.splitThenStream((String)str, (String)",").collect(Collectors.toList()).toArray(_Constants.emptyStringArray);
            }

            @Override
            public String asString(String[] strings) {
                return _NullSafe.stream((Object[])strings).collect(Collectors.joining(","));
            }
        };
    }

    public static Parser<List<MediaType>> forListOfJaxRsMediaTypes() {
        return new Parser<List<MediaType>>(){

            @Override
            public List<MediaType> valueOf(String str) {
                if (str == null) {
                    return Collections.emptyList();
                }
                return _Strings.splitThenStream((String)str, (String)",").map(MediaType::valueOf).collect(Collectors.toList());
            }

            @Override
            public String asString(List<MediaType> listOfMediaTypes) {
                return _NullSafe.stream(listOfMediaTypes).map(MediaType::toString).collect(Collectors.joining(","));
            }
        };
    }

    public static Parser<String> forETag() {
        return new Parser<String>(){

            @Override
            public String valueOf(String str) {
                return null;
            }

            @Override
            public String asString(String t) {
                return null;
            }
        };
    }
}

