/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.MediaType;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulHttpMethod;

public final class LinkRepresentation
extends JsonRepresentation {
    public LinkRepresentation() {
        this((JsonNode)new ObjectNode(JsonNodeFactory.instance));
        this.withMethod(RestfulHttpMethod.GET);
    }

    public LinkRepresentation(JsonNode jsonNode) {
        super(jsonNode);
    }

    public String getRel() {
        return this.asObjectNode().path("rel").textValue();
    }

    public LinkRepresentation withRel(String rel) {
        this.asObjectNode().put("rel", rel);
        return this;
    }

    public LinkRepresentation withRel(Rel rel) {
        return this.withRel(rel.getName());
    }

    public String getHref() {
        return this.asObjectNode().path("href").textValue();
    }

    public LinkRepresentation withHref(String href) {
        this.asObjectNode().put("href", href);
        return this;
    }

    public JsonRepresentation getValue() {
        return this.getRepresentation("value", new Object[0]);
    }

    public String getTitle() {
        return this.getString("title");
    }

    public LinkRepresentation withTitle(String title) {
        this.asObjectNode().put("title", title);
        return this;
    }

    public RestfulHttpMethod getHttpMethod() {
        String methodStr = this.asObjectNode().path("method").textValue();
        return RestfulHttpMethod.valueOf(methodStr);
    }

    public MediaType getType() {
        String typeStr = this.asObjectNode().path("type").textValue();
        if (typeStr == null) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        return MediaType.valueOf((String)typeStr);
    }

    public LinkRepresentation withMethod(RestfulHttpMethod httpMethod) {
        this.asObjectNode().put("method", httpMethod.name());
        return this;
    }

    public JsonRepresentation getArguments() {
        JsonNode arguments = this.asObjectNode().get("arguments");
        if (arguments == null || arguments.isNull()) {
            return JsonRepresentation.newMap(new String[0]);
        }
        return new JsonRepresentation(arguments);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getHref() == null ? 0 : this.getHref().hashCode());
        result = 31 * result + (this.getHttpMethod() == null ? 0 : this.getHttpMethod().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkRepresentation other = (LinkRepresentation)obj;
        if (this.getHref() == null ? other.getHref() != null : !this.getHref().equals(other.getHref())) {
            return false;
        }
        return this.getHttpMethod() == other.getHttpMethod();
    }

    @Override
    public String toString() {
        return "Link [rel=" + this.getRel() + ", href=" + this.getHref() + ", method=" + this.getHttpMethod() + ", type=" + this.getType() + "]";
    }
}

