/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.List;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.io.UrlUtils;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;

public final class UrlEncodingUtils {
    public static String urlDecode(String string) {
        return UrlUtils.urlDecodeUtf8((String)string);
    }

    public static List<String> urlDecode(List<String> values) {
        return _Lists.map(values, UrlUtils::urlDecodeUtf8);
    }

    public static String[] urlDecode(String[] values) {
        List<String> asList = Arrays.asList(values);
        return UrlEncodingUtils.urlDecode(asList).toArray(new String[0]);
    }

    public static String urlEncode(JsonNode jsonNode) {
        return UrlEncodingUtils.urlEncode(jsonNode.toString());
    }

    public static String urlEncode(JsonRepresentation jsonRepresentation) {
        return UrlEncodingUtils.urlEncode(jsonRepresentation.toString());
    }

    public static String urlEncode(String str) {
        return UrlUtils.urlEncodeUtf8((String)str);
    }

    private UrlEncodingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

