/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib.domainobjects;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

@Path(value="/services")
public interface DomainServiceResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/list\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response services();

    @DELETE
    @Path(value="/")
    public Response deleteServicesNotAllowed();

    @PUT
    @Path(value="/")
    public Response putServicesNotAllowed();

    @POST
    @Path(value="/")
    public Response postServicesNotAllowed();

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response service(@PathParam(value="serviceId") String var1);

    @DELETE
    @Path(value="/{serviceId}")
    public Response deleteServiceNotAllowed(@PathParam(value="serviceId") String var1);

    @PUT
    @Path(value="/{serviceId}")
    public Response putServiceNotAllowed(@PathParam(value="serviceId") String var1);

    @POST
    @Path(value="/{serviceId}")
    public Response postServiceNotAllowed(@PathParam(value="serviceId") String var1);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response actionPrompt(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @DELETE
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response deleteActionPromptNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response putActionPromptNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @POST
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response postActionPromptNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, @QueryParam(value="x-causeway-querystring") String var3);

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeAction(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @DELETE
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    public Response deleteInvokeActionNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);
}

