/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteraction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;

public class ObjectAndActionInvocation {
    private final ManagedObject objectAdapter;
    private final ObjectAction action;
    private final JsonRepresentation arguments;
    private final Can<ManagedObject> argAdapters;
    private final ManagedObject returnedAdapter;
    private final ActionResultReprRenderer.SelfLink selfLink;
    private final _Lazy<Can<ManagedObject>> elementAdapters = _Lazy.threadSafe(this::initElementAdapters);

    public static ObjectAndActionInvocation of(@NonNull ActionInteraction.Result actionInteractionResult, @NonNull JsonRepresentation argsJsonRepr, @NonNull ActionResultReprRenderer.SelfLink selfLink) {
        if (actionInteractionResult == null) {
            throw new NullPointerException("actionInteractionResult is marked non-null but is null");
        }
        if (argsJsonRepr == null) {
            throw new NullPointerException("argsJsonRepr is marked non-null but is null");
        }
        if (selfLink == null) {
            throw new NullPointerException("selfLink is marked non-null but is null");
        }
        return new ObjectAndActionInvocation(actionInteractionResult.getManagedAction().getOwner(), actionInteractionResult.getManagedAction().getAction(), argsJsonRepr, (Can<ManagedObject>)actionInteractionResult.getParameterList(), actionInteractionResult.getActionReturnedObject(), selfLink);
    }

    public ActionResultRepresentation.ResultType determineResultType() {
        ObjectSpecification returnTypeSpec = this.action.getReturnType();
        if (returnTypeSpec.getCorrespondingClass() == Void.TYPE) {
            return ActionResultRepresentation.ResultType.VOID;
        }
        ObjectSpecification actualReturnTypeSpec = this.returnedAdapter.getSpecification();
        if (ManagedObjects.isPacked((ManagedObject)this.returnedAdapter) || ObjectAndActionInvocation.isVector(actualReturnTypeSpec)) {
            if (((Can)this.elementAdapters.get()).isEmpty()) {
                Boolean isElementTypeAScalarValue = returnTypeSpec.getElementSpecification().map(elementSpec -> ObjectAndActionInvocation.isScalarValue(elementSpec)).orElse(false);
                return isElementTypeAScalarValue != false ? ActionResultRepresentation.ResultType.SCALAR_VALUES : ActionResultRepresentation.ResultType.LIST;
            }
            boolean isListOfDomainObjects = this.streamElementAdapters().allMatch(elementAdapter -> !ObjectAndActionInvocation.isScalarValue(elementAdapter.getSpecification()));
            return isListOfDomainObjects ? ActionResultRepresentation.ResultType.LIST : ActionResultRepresentation.ResultType.SCALAR_VALUES;
        }
        if (ObjectAndActionInvocation.isScalarValue(actualReturnTypeSpec)) {
            return ActionResultRepresentation.ResultType.SCALAR_VALUE;
        }
        return ActionResultRepresentation.ResultType.DOMAIN_OBJECT;
    }

    public Stream<ManagedObject> streamElementAdapters() {
        return ((Can)this.elementAdapters.get()).stream();
    }

    public boolean hasElements() {
        return !((Can)this.elementAdapters.get()).isEmpty();
    }

    public ObjectSpecification getReturnTypeSpecification() {
        return this.getAction().getReturnType();
    }

    public Either<ManagedObject, List<ManagedObject>> asEitherSingularOrPlural() {
        return this.getReturnTypeSpecification().isPlural() ? Either.right(Facets.collectionStream((ObjectSpecification)this.getReturnTypeSpecification(), (ManagedObject)this.getReturnedAdapter()).collect(Collectors.toList())) : Either.left((Object)this.getReturnedAdapter());
    }

    private Can<ManagedObject> initElementAdapters() {
        return (Can)Facets.collectionStream((ManagedObject)this.returnedAdapter).collect(Can.toCan());
    }

    private static boolean isScalarValue(@NonNull ObjectSpecification spec) {
        if (spec == null) {
            throw new NullPointerException("spec is marked non-null but is null");
        }
        return spec.isValue();
    }

    private static boolean isVector(@NonNull ObjectSpecification spec) {
        if (spec == null) {
            throw new NullPointerException("spec is marked non-null but is null");
        }
        return Facets.collectionIsPresent((ObjectSpecification)spec);
    }

    private ObjectAndActionInvocation(ManagedObject objectAdapter, ObjectAction action, JsonRepresentation arguments, Can<ManagedObject> argAdapters, ManagedObject returnedAdapter, ActionResultReprRenderer.SelfLink selfLink) {
        this.objectAdapter = objectAdapter;
        this.action = action;
        this.arguments = arguments;
        this.argAdapters = argAdapters;
        this.returnedAdapter = returnedAdapter;
        this.selfLink = selfLink;
    }

    public ManagedObject getObjectAdapter() {
        return this.objectAdapter;
    }

    public ObjectAction getAction() {
        return this.action;
    }

    public JsonRepresentation getArguments() {
        return this.arguments;
    }

    public Can<ManagedObject> getArgAdapters() {
        return this.argAdapters;
    }

    public ManagedObject getReturnedAdapter() {
        return this.returnedAdapter;
    }

    public ActionResultReprRenderer.SelfLink getSelfLink() {
        return this.selfLink;
    }
}

