/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal;

import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.ValueSchemaFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.stereotype.Component;

@Component
@Named(value="causeway.viewer.ro.ValueSchemaFactoryDefault")
public class ValueSchemaFactoryDefault
implements ValueSchemaFactory {
    private final Map<Class<?>, Factory> propertyFactoryByClass = _Maps.newHashMap();

    public ValueSchemaFactoryDefault() {
        this.propertyFactoryByClass.put(Boolean.TYPE, BooleanSchema::new);
        this.propertyFactoryByClass.put(Boolean.class, BooleanSchema::new);
        this.propertyFactoryByClass.put(Byte.TYPE, IntegerSchema::new);
        this.propertyFactoryByClass.put(Byte.class, IntegerSchema::new);
        this.propertyFactoryByClass.put(Short.TYPE, IntegerSchema::new);
        this.propertyFactoryByClass.put(Short.class, IntegerSchema::new);
        this.propertyFactoryByClass.put(Integer.TYPE, IntegerSchema::new);
        this.propertyFactoryByClass.put(Integer.class, IntegerSchema::new);
        this.propertyFactoryByClass.put(BigInteger.class, NumberSchema::new);
        this.propertyFactoryByClass.put(Long.TYPE, NumberSchema::new);
        this.propertyFactoryByClass.put(Long.class, NumberSchema::new);
        this.propertyFactoryByClass.put(Timestamp.class, NumberSchema::new);
        this.propertyFactoryByClass.put(BigDecimal.class, NumberSchema::new);
        this.propertyFactoryByClass.put(Float.TYPE, NumberSchema::new);
        this.propertyFactoryByClass.put(Float.class, NumberSchema::new);
        this.propertyFactoryByClass.put(Double.TYPE, NumberSchema::new);
        this.propertyFactoryByClass.put(Double.class, NumberSchema::new);
        this.propertyFactoryByClass.put(Character.TYPE, StringSchema::new);
        this.propertyFactoryByClass.put(Character.class, StringSchema::new);
        this.propertyFactoryByClass.put(char[].class, StringSchema::new);
        this.propertyFactoryByClass.put(String.class, StringSchema::new);
        this.propertyFactoryByClass.put(UUID.class, UUIDSchema::new);
        this.propertyFactoryByClass.put(java.util.Date.class, DateTimeSchema::new);
        this.propertyFactoryByClass.put(DateTime.class, DateTimeSchema::new);
        this.propertyFactoryByClass.put(LocalDateTime.class, DateTimeSchema::new);
        this.propertyFactoryByClass.put(Date.class, DateSchema::new);
        this.propertyFactoryByClass.put(LocalDate.class, DateSchema::new);
        this.propertyFactoryByClass.put(byte[].class, ByteArraySchema::new);
        this.propertyFactoryByClass.put(Blob.class, ByteArraySchema::new);
    }

    @Override
    public Optional<Schema<?>> schemaForValue(Class<?> cls) {
        if (cls == null) {
            return Optional.empty();
        }
        if (cls.isEnum()) {
            List enumNames = _NullSafe.stream((Object[])cls.getEnumConstants()).map(input -> ((Enum)input).name()).collect(Collectors.toList());
            StringSchema schema = new StringSchema()._enum(enumNames);
            return Optional.of(schema);
        }
        Factory factory = this.propertyFactoryByClass.get(cls);
        if (factory != null) {
            return Optional.ofNullable((Schema)factory.get());
        }
        return Optional.empty();
    }

    private static interface Factory
    extends Supplier<Schema<?>> {
    }
}

