/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.causeway.applib.util.Enums;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.causeway.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.causeway.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.BodyArgs;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;

public enum MemberType {
    PROPERTY("properties/", RepresentationType.OBJECT_PROPERTY, _Maps.unmodifiable((Object)"modify", (Object)MutatorSpec.of(Rel.MODIFY, PropertySetterFacet.class, RestfulHttpMethod.PUT, BodyArgs.ONE), (Object)"clear", (Object)MutatorSpec.of(Rel.CLEAR, PropertyClearFacet.class, RestfulHttpMethod.DELETE, BodyArgs.NONE))),
    COLLECTION("collections/", RepresentationType.OBJECT_COLLECTION, Collections.emptyMap()),
    ACTION("actions/", RepresentationType.OBJECT_ACTION, _Maps.unmodifiable((Object)"invokeQueryOnly", (Object)MutatorSpec.of(Rel.INVOKE, ActionInvocationFacet.class, RestfulHttpMethod.GET, BodyArgs.MANY, "invoke"), (Object)"invokeIdempotent", (Object)MutatorSpec.of(Rel.INVOKE, ActionInvocationFacet.class, RestfulHttpMethod.PUT, BodyArgs.MANY, "invoke"), (Object)"invoke", (Object)MutatorSpec.of(Rel.INVOKE, ActionInvocationFacet.class, RestfulHttpMethod.POST, BodyArgs.MANY, "invoke")));

    private final String urlPart;
    private final String name;
    private final RepresentationType representationType;
    private final Map<String, MutatorSpec> mutators;

    private MemberType(String urlPart, RepresentationType representationType, Map<String, MutatorSpec> mutators) {
        this.urlPart = urlPart;
        this.representationType = representationType;
        this.mutators = mutators;
        this.name = Enums.enumToCamelCase((Enum)this);
    }

    public boolean isProperty() {
        return this == PROPERTY;
    }

    public boolean isCollection() {
        return this == COLLECTION;
    }

    public boolean isAction() {
        return this == ACTION;
    }

    public static MemberType lookup(String memberTypeName) {
        for (MemberType memberType : MemberType.values()) {
            if (!memberType.getName().equals(memberTypeName)) continue;
            return memberType;
        }
        return null;
    }

    public static MemberType of(ObjectMember objectMember) {
        return objectMember.isAction() ? ACTION : (objectMember.isOneToOneAssociation() ? PROPERTY : COLLECTION);
    }

    public static MemberType determineFrom(ObjectFeature objectFeature) {
        if (objectFeature instanceof ObjectAction) {
            return ACTION;
        }
        if (objectFeature instanceof OneToOneAssociation) {
            return PROPERTY;
        }
        if (objectFeature instanceof OneToManyAssociation) {
            return COLLECTION;
        }
        return null;
    }

    @Generated
    public String getUrlPart() {
        return this.urlPart;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public RepresentationType getRepresentationType() {
        return this.representationType;
    }

    @Generated
    public Map<String, MutatorSpec> getMutators() {
        return this.mutators;
    }
}

